#!/bin/sh

# shell script to create initial flatfile database

# First kill everything
rm -f *.dat

# Make some members

./flatstore <<EOF
member create 10001,Mr,Neil,Matthew,The Barn,Main Road,Little Village,New Town,NN,NN1 1AA,0123 1234567
member create 10002,Mr,Rick,Stones,92,Church Street,Small Village,Newish Town,LE,LE1 1AA,0123 2345678
member create 10003,Mr,Richard,Neill,The Cottage,Quiet St,Tiny Village,Old Town,LE,LE2 2BB,0123 3456789
EOF

# Make some DVD titles

./flatstore <<EOF
title create Grand Illusion,0780020707,Jean Renoir,Thriller,15,Jean Gabin,,19380101,2.99
title create Seven Samurai,0780020685,Akira Kurosawa,Thriller,18,Takashi Shimura,Toshiro Mifune,19540101,2.50
title create The Lady Vanishes,0780020723,Alfred Hitchcock,Romance,12,Michael Redgrave,,19380101,1.50
title create Amarcord,0780020693,Federico Fellini,Comedy,18,Pupella Maggio,,19740101,2.50
title create The 400 Blows,1572525320,Francois Truffaut,Thriller,15,Jean-Pierre Leaud,,19590101,1.00
title create Beauty and The Beast,0780020715,Jean Cocteau,Romance,PG,Jean Marais,,19460101,3.25
title create A Night To Remember,1559408685,Roy Ward Baker,Romance,12,Kenneth More,,1958,2.10
title create The Killer,155940860X,John Woo,Thriller,18,Chow Yun Fat,,19900101,1.50
title create Hard Boiled,1559408677,John Woo,Thriller,18,Chow Yun Fat,,19920101,1.50
title create Walkabout,0780020847,Nicolas Roeg,Thriller,15,Jenny Agutter,,19710101,2.00
title create The Seventh Seal,6305174083,Ingmar Bergman,Comedy,U,Gunnar Bjornstrand,Max Von Sydow,19570101,2.00
title create This Is Spinal Tap,1559408758,Rob Reiner,Comedy,18,Michael McKean,Christopher Guest,19840101,2.00
title create The Silence Of the Lambs,6305050058,Johnathon Demme,Thriller,18,Anthony Hopkins,Jodie Foster,19900101,3.00
title create Samurai 1:Musashi Miyamoto,0780021045,Hiroshi Inagaki,Thriller,18,Toshiro Mifune,,19540101,1.25
title create Samurai 2:Duel at Ichijoji Temple,6305028699,Hiroshi Inagaki,Thriller,18,Toshiro Mifune,,19550101,1.25
title create Samurai 3:Duel At Ganryu Island,0780021061,Hiroshi Inagaki,Thriller,18,Toshiro Mifune,,19560101,1.50
title create Salo,1559408855,Pier Paolo Pasolini,Foreign,U,Paolo Bonacelli,Giorgio Cataldi,19750101,1.25
title create Naked Kiss,0780021088,Samuel Fuller,Action,PG,Constance Towers,,19640101,1.10
title create Shock Corridor,0780021096,Samuel Fuller,Action,PG,Peter Breck,,19630101,1.10
title create Sid And Nancy,6305094926,Alex Cox,Comedy,18,Gary Oldman,Chloe Webb,19860101,2.00
title create Dead Ringers,1559408871,David Cronenburg,Thriller,18,Jeremy Irons,Genevieve Bujold,19880101,3.50
title create Summertime,6305094934,David Lean,Romance,U,Katherine Hepburn,Rossano Brazzi,19550101,2.00
title create Robocop,1559408898,Paul Verhoeven,Thriller,15,Peter Weller,Nancy Allen,19870101,2.25
title create High And Low,0780021509,Akira Kurosawa,Foreign,18,Toshiro Mifune,,19630101,2.00
title create Alphaville,0780021541,Jean-Luc Godard,Science Fiction,15,Eddie Constantine,,19650101,1.50
EOF

# Create some disks, three for each title

for d in 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25
do
    for c in 1 2 3
    do 
	echo disk create $d
    done
done | ./flatstore



	



