
/***************************************************************

Demonstration code from 'Professional Linux Programming'

Written by Neil Matthew, Rick Stones et. al.

Copyright (C) 2000 Wrox Press.

http://www.wrox.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

***************************************************************/

/*
  Header file for PostgreSQL specific implementation of DVD store 
*/

/* Database utilities */
int pg_open_db(const char *user, const char *passwd);
void pg_close_db(void);
void pg_print_debug(char *file, int line, struct sqlca sqlca_st, char *msg);
int pg_check_db_is_connected(char *message);

/* Disk specific functions */
int pg_disk_delete(const int disk_id_to_delete);
int pg_disk_get(const int req_disk_id, dvd_disk *disk_ptr);
int pg_disk_insert(dvd_disk *disk_ptr);
int pg_disk_rental_cancel_by_member(const int member_id_to_use);
int pg_disk_search(const int title_id_to_find, int *result_ids[], int *count);
int pg_disk_set(const dvd_disk *disk_ptr);
int pg_rent_disk(const int member_id_renting, const int title_id_to_rent, char *today_date, int *disk_id);

/* Lookup functions */
int pg_get_class_list(char **class_list[], int *count);
int pg_get_genre_list(char **genre_list[], int *count);
void pg_get_err_text(const int err_number, char **message_to_show);

/* Memeber specific functions */
int pg_member_delete(const int member_id_to_delete);
int pg_member_get_id_from_number(const char *req_member_no, int *member_id_ptr);
int pg_member_get(int req_member_id, dvd_store_member *member_ptr);
int pg_member_insert(dvd_store_member *member_ptr);
int pg_member_search(const char *lname_to_find, int *result_ids[], int *count);
int pg_member_set(const dvd_store_member *member_ptr);

/* Title specific functions */
int pg_title_delete(const int title_id_to_delete);
int pg_title_get(const int req_title_id, dvd_title *title_ptr);
int pg_title_insert(dvd_title *title_ptr);
int pg_title_search(const char *title_to_find, const char *name_to_find, int *result_ids[], int *count);
int pg_title_set(const dvd_title *title_ptr);


/* Misc. functions */
int pg_disk_return(const int disk_id_returned, int *member_id_who_rented, char *date_rented);
int pg_make_reservation(const int title_id_to_book, const char *date, const int member_id_booking);
int pg_overdue_disks(const char *date1, const char *date2, int *disk_ids[], int *count_returned);
int pg_rented_disk_info(int disk_id_to_check, int *member_id_who_rented, char *date_disk_was_rented);
int pg_reserve_title_cancel(const int member_id);
int pg_reserve_title_query_by_member(const int member_id, int *title_id);
int pg_reserve_title_query_by_titledate(const int title_id_to_check, const char *date_reserved, int *member_ids[], int *count_returned);
int pg_title_available(const int title_id_to_check, const char *date_req, int *count);


/* Utility routine */
void string_trim(char *string, int len);


