#include <stdio.h>
#include "mpi.h"

static int nproc;
static int iproc;
extern void bladeenc(int argc, char **argv);

int main(int argc, char **argv)
{
   MPI_Init(&argc, &argv);
   MPI_Comm_size(MPI_COMM_WORLD, &nproc);
   MPI_Comm_rank(MPI_COMM_WORLD, &iproc);
   {
      int first;
      int n;
      int remainder;
      int nt;
      
      nt = argc -1;
      remainder = nt / nproc;
      n = nt / nproc;
      
      if (remainder > 0)
      {
         if (iproc < remainder)
         {
            n++;
            first = iproc * n;
         }
         else
         {
            first = (n+1) * remainder + (iproc - remainder) * n;
         }
      }
      else
      {
         first = iproc * n;
      }
      
      bladeenc(n+1, argv+first);
   }
   
   MPI_Finalize();
   
   return 1;
}
