//  Window Dimension Methods
//  These are the same as Document_getVisibleWidth and Document_getVisibleHeight

//  Prototypes

Window.prototype.getInnerWidth=Window_getInnerWidth;

Window.prototype.getInnerHeight=Window_getInnerHeight;

//  Definitions

function Window_getInnerWidth()
{
  var value;

  if(ns)
    value=window.innerWidth;
  if(ie)
    value=document.body.clientWidth;

  return value;
}

function Window_getInnerHeight()
{
  var value;

  if(ns)
    value=window.innerHeight;
  if(ie)
    value=document.body.clientHeight;

  return value;
}


//
//  ECMA Global Object Methods
//

//  Identify the global undefined property

var undefined;
window.undefined=undefined;

//  Window.encodeURI(), Window.encode URIComponent(),
//  Window.decodeURI(), Window.decodeURIComponent()

function __TestUriMethods__(){	
	if( !window.encodeURI ) window.encodeURI = encodeURI;
	if( !window.decodeURI ) window.decodeURI = decodeURI;
	if( !window.encodeURIComponent ) window.encodeURIComponent = encodeURIComponent;
	if( !window.decodeURIComponent ) window.decodeURIComponent = decodeURIComponent;
	return;
	
	//encode function described on pages 79 to 80
	function Encode( string, unescapedSet ){
		var len, R, S, k, C, charCode, V;
		//step 1
		len = String(string).length;
		
		//step 2
		R = "";
		
		//step 3
		k = 0;
		
		//step 4
		while( k != len ){
			//step 4 branch false
			
			//step 5
			C = String(string).charAt(k);
			//step 6
			if( eval("/[" + ((C=="\\")? "\\\\" : C) + "]/g").test(String(unescapedSet)) ){
				//step 6 branch false  (I used opposite logic here so true in the if is 
				//						false in the algorithm).
				
				//step 7
				S = C;
				
				//step 8 goto step 24
				
			} else {
				//step 6 branch true
				
				charCode = C.charCodeAt(0);
				//step 9
				if( charCode > 0xDC00 && charCode < 0xDFFF )
					//step 9 branch true;
					throwError();
				//step 9 branch false
				
				//step 10
				if( charCode < 0xD800 || charCode > 0xDBFF ){
					//step 10 branch true
					V = charCode;
					//goto step 16
					
				} else {
					//step 10 branch false
					
					//step 11
					k++;
					
					//step 12
					if( k == len )
						//step 12 branch true
						throwError();
					//step 12 branch false
					
					//step 13
					charCode = String(string).charAt(k).charCodeAt(0);
					
					//step 14
					if( charCode < 0xDC00 || charCode > 0xDFFF )
						//step 14 branch true
						throwError();
					//step 14 branch false
					
					//step 15 performs the following binary manipulation in order to encode two
					//characters into a single integer value.
					//
					//	                         first character                        second character
					//	            --------------------------------------  ------------------------------------------------
					//	#'s                   1101 10vv vvww wwxx                               1101 11yy yyzz zzzz
					//	mask                  1111 1100 0000 0000                               1111 1100 0000 0000
					//	result                1101 1000 0000 0000 = 0xD800                      1101 1100 0000 0000 = 0xDC00
					//	These results are used below
					//	
					//	
					//	#'s                   1101 10vv vvww wwxx                               1101 11yy yyzz zzzz
					//	subtract              1101 1000 0000 0000 = 0xD800                      1101 1100 0000 0000 = 0xDC00
					//	result                0000 00vv vvww wwxx                               0000 00yy yyzz zzzz
					//	Mult                  0000 0100 0000 0000                     
					//	result      0000 vvvv wwww xx00 0000 0000           
					//			
					//	
					//	first       0000 vvvv wwww xx00 0000 0000
					//	second      0000 0000 0000 00yy yyzz zzzz
					//	sum =       0000 vvvv wwww xxyy yyzz zzzz
					//	add			0000 0001 0000 0000 0000 0000
					//	result(V)   000u uuuu wwww xxyy yyzz zzzz   where 000u uuuu = vvvv + 1
					
					//step 15
					V = (( C.charCodeAt(0) - 0xD800) * 0x400 + (charCode - 0xDC00) + 0x10000);
					
					//Note:  At this point V has a value of greater than 0xFFFF.
					//		It is a combination of two characters.
				}
				
				//steps 16 through 25
				/*
					These steps are very inefficient if you follow the algorithm exactly.
					I have used bit matching from the table on page 81 in order to speed
					up the code.
					
					Using this table I notice if the character code falls between certain
					values.  If they fall within these values then I use binary operations
					to perform the transformation.
					
					The values in my comments below are in binary.  If I write "aaaa" I am
					refering to bits, and if I write "A" I am refering to the bit value
					converted to a two hex digit value such that aaaa == A.
					
					Be carful of my notation.  "%" + A is string connotation.  Thus if A 
					was 4 then the above equation would be "%04" not "%4".
					
					All hex notation begins with 0x, same as in JS.
					
					All hex conversions are accomplished using the Number.toString(base)
					method where the base used is 16 (for hex).  
					
				*/
				if( V <= 0x7F ){
					// between  0000 0000  and  0111 1111
						// convert 0zzz zzzz to 
						//		Z = 0zzz zzzz
						//convert to a string  S = "%" + Z
					S = "%" + V.toString(16);
				
				} else if( V <= 0x07FF ){
					//between  0000 0000 1000 0000  and  0000 0111 1111 1111
						//convert  0000 0yyy yyzz zzzz   to  
						//		Y = 110y yyyy  
						//		Z = 10zz zzzz
						//convert to a string   S = "%" + Y + "%" + Z
					S = "%" + (0xC0 + ( (V & 0x7C0) / 0x40)).toString(16) + 
						"%" + (0x80 + (V & 0x3F)).toString(16);
				
//NOTE This else if block is redundant since it performs the exact same operations as the next one -- remove it
// start remove code
//				} else if( V <= 0xD7FF ){
//					//between  0000 1000 0000 0000  and  1101 1011 1111 1111
//						//convert  xxxx yyyy yyzz zzzz to  
//						//		X = 1110 xxxx
//						//		Y = 10yy yyyy
//						//		Z = 10zz zzzz
//						//convert to a string   S = "%" + X + "%" + Y + "%" + Z
//					S = "%" + (0xE0 + ( (V & 0xF000) / 0x1000)).toString(16) + 
//						"%" + (0x80 + ( (V & 0x0FD0) / 0x40)).toString(16) + 
//						"%" + (0x80 + (V & 0x3F)).toString(16);
// end remove code

				} else if( V <= 0xFFFF ){
					//between  1101 1100 0000 0000  and  1111 1111 1111 1111
						//convert xxxx yyyy yyzz zzzz to
						//		X = 1110 xxxx
						//		Y = 10yy yyyy
						//		Z = 10zz zzzz
						//convert to a string   S = "%" + X + "%" + Y + "%" + Z
					S = "%" + (0xE0 + ( (V & 0xF000) / 0x1000)).toString(16) + 
						"%" + (0x80 + ( (V & 0x0FD0) / 0x40)).toString(16) + 
						"%" + (0x80 + (V & 0x3F)).toString(16);
				
				} else {
					//this is the value of the result of step 15 above
					//between  0000 0001 0000 0000 0000 0000  and  0000 1111 1111 1111 1111 1111
						//convert 0000 uuuu wwww xxyy yyzz zzzz to
						//		A = 1111 0uuu
						//		B = 10uu wwww
						//		C = 10xx yyyy
						//		D = 10zz zzzz
						//convert to string  S = "%" + A + "%" + B + "%" + C + "%" + D
					S = "%" + (0xF0 + ( (V & 0x1C0000) / 0x40000)).toString(16) + 
						"%" + (0x80 + ( (V & 0x03F000) / 0x1000)).toString(16) + 
						"%" + (0x80 + ( (V & 0x0FC0) / 0x40)).toString(16) + 
						"%" + (0x80 + (V & 0x3F)).toString(16);
					
					//step 26 is goto step 4
				}
			}
			//step 24
			R += S;
			k++;
		}
		//step 4 branch true
		return R;
		
		function throwError(){
			if( window.Error ){
				var err = new Error( "Invalid URI unicode character." );
				err.name = "URIError";
				throw err;
			} else return 1/0; //forces an error state
		}
	}
	
	function Decode( string, reservedSet ){
		//step 1
		var len = String(string).length;
		
		//steps 2 and 3
		var R="", k=0, C, start, B, n, S;
		var octets, j, V;
		
//redundant code.  Covered by while statement below
//start remove code
//
//		//step 4
//		if( len == 0 ) return R;
//
//end remove code
		
		//step 4
		while( k != len ){
			//step 4 false branch (I used reverse logic)
			
			//Step 5 and step 40
			S = C = string.charAt(k);
			
			//Step 6
			if( C == "%" ){
				//step 6 false branch (I used reverse logic).
				
				//step 7
				start = k;
				
				//steps 8-10 performed by the getEscapedCharValue function 
				B = getEscapedCharValue( String(string).substring( k+1, k+3) );
				
				//step 11
				k += 2;
				
				//step 12
				if( B & 0x80 ){
					//step 12 false branch (I used reverse logic)
					
					//step 13
					n=0;
					while( ((B<<n) & 0x80) != 0 ) n++;
					
					//step 14
					if( n == 1 || n > 4 ) 
						//step 14 true branch
						throwError();
					//step 14 false branch
					
					//step 15
					octets = new Array(n);
					
					//step 16
					octets[0] = B;
					
					//step 17
					if( k + (3*(n-1)) >= len ) 
						//step 17 true branch
						throwError();
					//step 17 false branch
					
					//step 18
					j = 1;
					
					//step 19
					while( j != n ){
						//step 19 false branch (I used reverse logic)
						
						//step 20
						k++;
						
						//step 21
						if( string.charAt(k) != "%" ) 
							//step 21 true branch
							throwError();
						//step 21 false branch
						
						//steps 22 and 23 performed by the getEscapedCharValue function 
						B = getEscapedCharValue( String(string).substring( k+1, k+3) );
						
						//step 24
						if( (B & 0x80) != 0x80 || (B & 0x40) != 0 ) 
							//step 24 true branch
							throwError();
						//step 24 false branch
						
						//step 25
						k+=2;
						
						//step 26
						octets[j] = B;
						
						//step 27
						j++;
						
						//step 28 goto step 19
					}
					//step 19 true branch
					
					//steps 29 through 41 is the reverse operation of steps 16 through 25 in the encode function.
					//see the encode operation for more details
					
					//steps 29 through 40 (while following step 12 false branch) are mingled here
					//NOTE:  n==1 was handled by step 12
					if( n == 2 ){
						//steps 29 and 30 following step 30 true branch 2 octects
						//goto step 36
						
						//step 36 combined with step 40
						S = String.fromCharCode(	((octets[0] & 0x1f)<< 6) + 
														(octets[1] & 0x3F )
							);
						//step 37 performed after the if blocks
						
					} else if( n == 3 ){
						//steps 29 and 30 following steps 30 true branch where there are 3 octects
						//goto step 30
						
						//step 30 combined with step 40
						S = String.fromCharCode(	((octets[0] & 0x0f)<< 12) + 
													((octets[1] & 0x3F ) << 6) + 
													(octets[2] & 0x3F ) 
							);
						//step 37 performed after the if blocks
							
					} else {
						//steps 29 and 30 following steps 30 false branch
						
//Code error.  I did not perform step 31.  The following edit fixes this
//start code fix
						
						//the following is the steps taken to convert the octets (when there are 4 of them)
						//into the two character encoded value.
						
						//A = Octet 0
						//B = Octet 1
						//C = Octet 2
						//D = Octet 3

						//A = 1111 0uuu   uses mask of 0000 0111 = 0x03 to extract the usable bits
						//B = 10uu wwww   uses mask of 0011 1111 = 0x3f to extract the usable bits
						//C = 10xx yyyy   uses mask of 0011 1111 = 0x3f to extract the usable bits
						//D = 10zz zzzz   uses mask of 0011 1111 = 0x3f to extract the usable bits
						
						//convert to  000u uuuu wwww xxyy yyzz zzzz  
						//subtract    0000 0001 0000 0000 0000 0000
						//result(V)   0000 vvvv wwww xxyy yyzz zzzz
						
						//step 29
						V = ((octets[0] & 0x1f)<<18) + //decodes A
							((octets[1] & 0x3f)<<12) + //decodes B
							((octets[2] & 0x3f)<< 6) + //decodes C
							((octets[3] & 0x3f)<< 0) - //decodes D
									0x010000           //turns u bits into v bits
						
						//step 30 is skiped (will never happen with 4 octets);
						
						//step 31
						if( V > 0x10FFFF )
							//step 31 true branch
							throwError();
						//step 31 false branch
//end code fix						
						//steps 32 through 34
						S = String.fromCharCode(	((	((octets[0] & 0x03)<<2 ) +
														(octets[1] & 0x30) - 1
													) << 6 ) +
													((octets[1] & 0x0f ) << 2 ) +
													((octets[2] & 0x30 ) >> 4 ) +
													0xD800
							) +
							String.fromCharCode(	((octets[2] & 0xF) << 6 ) +
													(octets[3] & 0x3F ) + 
													0xDC00
							);
						//step 35 goto step 41 (skips step 37 below because n==3)
					}

//This is a code fix where I did not perform steps 37 with the step 12 false branch
//start code fix					
					//this if block performs step 37 
					if( n<4 ){
						//step 37
						C = S;
						if( eval("/[" + ((C=="\\")? "\\\\" : C) + "]/g").test(String(reservedSet)) ){
							//step 37 false path
							
							//step 38
							S = string.substring( start, k+1 );
						//step 39 goto step 41
					
					}
					//step 40 combined with step 36 above
//end code fix

					//step 41
					R += S;
					
					//step 42
					k++;
					
					//step 43
					continue;
						//goto step 4 by continueing the while loop.
				}
				//step 12 true branch
				
				//step 36
				S = C = String.fromCharCode(B);
				if( eval("/[" + ((C=="\\")? "\\\\" : C) + "]/g").test(String(reservedSet)) )
					S = string.substring( start, k+1 );
			}
			//step 40 performed with step 5
			
			//step 41
			R += S;
			
			//step 42
			k++;
			
			//step 43 goto step 4
		}
		
		//step 4 true branch (used reverse logic)
		return R;
		
		
		
		//the following function performs steps 8 through 10 and steps 22 and 23.
		function getEscapedCharValue( string ){
			var len = String(string).length;
			if( len > 2 || len < 1 ) throwError();
			var B = parseInt( String(string), 16);
			if( isNaN( B ) || isNaN( parseInt( String(string).charAt(1), 16 ) ) ) 
				throwError();
			return B;
		}
		
		function throwError(){
			if( window.Error ){
				var err = new Error( "Invalid URI unicode character." );
				err.name = "URIError";
				throw err;
			} else return 1/0; //forces an error state
		}
	}
	
	function encodeURI( uri ){
		var set = "#";  
		set += ";/?:@&=+$,";					//uriReserved 
												//uriUnescaped
		set += "abcdefghijklmnopqrstuvwxyz";		//uriAlphaLowerCase
		set += "ABCDEFGHIJKLMNOPQRSTUVWXYZ";		//uriAlphaUpperCase
		set += "0123456789";						//DecimalDigit
		set += "-_.!~*'()";							//uriMark
		
		return Encode( String(uri), set );
	}
	function encodeURIComponent( uriComponent ){
		var set = "";  
												//uriUnescaped
		set += "abcdefghijklmnopqrstuvwxyz";		//uriAlphaLowerCase
		set += "ABCDEFGHIJKLMNOPQRSTUVWXYZ";		//uriAlphaUpperCase
		set += "0123456789";						//DecimalDigit
		set += "-_.!~*'()";							//uriMark
		
		return Encode( String(uriComponent), set );
	}

	function decodeURI( encodedURI ){
		var set = "#";  
		set += ";/?:@&=+$,";					//uriReserved 
		return Decode( String(encodedURI), set );
	}
	function decodeURIComponent( encodedURIComponent ){
		var set = "";  
		
		return Decode( String(encodedURIComponent), set );
	}
}
__TestUriMethods__();	








