function dragObject(boundBox) {
	var el = null
	if (!boundBox) return
	var bounds = document.getElementById(boundBox)
//Methods
	var DRAG_begindrag = function(e) {
		var btn = cs.isNS() ? e.button : event.button
	        if (btn <= 1) {
			document.onmousemove = DRAG_drag
			document.onmouseup = DRAG_enddrag
			el.DRAG_dragging = true
		}
		return true
	}

	var DRAG_drag = function(e) {
		var evtX = cs.isNS() ? e.pageX : event.x
        	if (el.DRAG_dragging == true) {
			var minX = bounds.offsetLeft
			var maxX = minX + bounds.offsetWidth
			el.style.left = Math.max(minX, Math.min(maxX-el.offsetWidth, evtX)) + "px"  
	                return false
        	} else return true
	}

	var DRAG_enddrag = function(e) {
		el.DRAG_dragging = false
		el = null
		document.onmousemove = null
		document.onmouseup = null
		return true
	}

//Public Methods
	this.allowDrag = function(dragEl, e) {
		el = dragEl
		DRAG_begindrag(e)
	}
}

//-------- end drag code; start moving code

function moveObj(elID, boundingBox, clashItemID) {
	if (!elID || !boundingBox) return
	var movableEl = null
	var bounds = null
	var clash = null
	var dX = 3
	var dY = 3
	var dT = 75
	var timerID = null
	var globalIdx = 0

	if (window["autoMove"]) {
		globalIdx = autoMove.length
	} else {
		autoMove = new Array()
	}
//Global function to allow ball to move
	autoMove[globalIdx] = function() {
		var x = movableEl.offsetLeft + dX
		var y = movableEl.offsetTop + dY
		if (x < bounds.offsetLeft || x > bounds.offsetLeft+bounds.offsetWidth-movableEl.offsetWidth)
			dX = -dX
		if (y < bounds.offsetTop || y > bounds.offsetTop+bounds.offsetHeight-movableEl.offsetHeight)
			dY = -dY
		if (!isAClash(x, y))
			moveEl(x, y)
		else	dY = -dY
		if (isBehind(y)) clearInterval(timerID)
	}

//Private Methods
	var isAClash = function(x, y) {
		return (clash.offsetTop < y + movableEl.offsetHeight &&
			x+movableEl.offsetWidth > clash.offsetLeft && 
			x < clash.offsetLeft+clash.offsetWidth
			)
	}

	var isBehind = function(y) {
		var ec = y + movableEl.offsetHeight / 2
		var cc = clash.offsetTop + clash.offsetHeight / 2
		return (ec > cc)
	}

	var moveEl = function(x, y) {
		var minX = bounds.offsetLeft
		var maxX = minX + bounds.offsetWidth
		var minY = bounds.offsetTop
		var maxY = minY + bounds.offsetHeight
		var eX = Math.max(minX, Math.min(maxX-movableEl.offsetWidth, x))
		var eY = Math.max(minY, Math.min(maxY-movableEl.offsetHeight, y))
		movableEl.style.left = eX + "px"
		movableEl.style.top = eY + "px"
	}

	this.setDirection = function(x, y) {
		dX = x
		dY = y
	}

	this.setSpeed = function(t) { dT = t }

	this.run = function() {
		movableEl = document.getElementById(elID)
		bounds = document.getElementById(boundingBox)
		clash = document.getElementById(clashItemID)
		timerID = setInterval("autoMove[" + globalIdx + "]()", dT)
	}
}
