//
//	Definicja konstruktora klasy Validate
//

function Validate() {}


Validate.prototype.isOnlyAlphaNumeric = function(string)
{
	var invalidCharactersRegExp = /[^a-z\d ]/i;
	var isValid = !(invalidCharactersRegExp.test(string));
	
	return isValid;
}


Validate.prototype.isOnlyAlphaNumericNoSpace = function(string)
{
   var invalidCharactersRegExp = /[^a-z\d]/i;
   var isValid = !(invalidCharactersRegExp.test(string));
      
   return isValid;
}



Validate.prototype.isOnlyAlphabetic = function(string)
{
	invalidCharactersRegExp = /[^a-z ]/i;
	var isValid = !(invalidCharactersRegExp.test(string));
	
	return isValid;
}

Validate.prototype.isOnlyNumeric = function(string)
{
	var invalidCharactersRegExp = /[^\d]/;
	var isValid = !(invalidCharactersRegExp.test(string));
	
	return isValid;
}

Validate.prototype.isValidInteger = function(string)
{
	var invalidCharactersRegExp = /[^\d-]/;
	var isValid = !(invalidCharactersRegExp.test(string));
	
	return isValid;
}

Validate.prototype.isValidFloatingPoint = function(string)
{
	var invalidCharactersRegExp = /[^\d\.-]/;
	var isValid = !(invalidCharactersRegExp.test(string));
	
	return isValid;
}

Validate.prototype.isValidAge = function(age)
{
	var isValid = false;
	if (this.isOnlyNumeric(age))
	{
		isValid = (parseInt(age) >= 0 && parseInt(age) < 140)
	}
	
	return isValid;
}

Validate.prototype.isValidPassword = function(password)
{
	var invalidCharactersRegExp = /[^a-z\d]/i
	var isValid = !(invalidCharactersRegExp.test(password));
	if (isValid)
	{
		isValid = (password.length >= 8 && password.length <= 16);
	}
	return isValid;
	
}



Validate.prototype.isValidTelephoneNum = function(telephoneNum)
{
   var validFormatRegExp = /^(\+\d{1,3} ?)?(\(\d{1,5}\)|\d{1,5}) ?\d{3,4} ?\d{0,7}(?: (x|xtn|extn?|extension)\.? ?\d{1,5})?$/i;
//Pamitaj, by wpisa to wyraenie regularne w jednej linii.
   var isValid = validFormatRegExp.test(telephoneNum);
   return isValid;
   
}




Validate.prototype.isValidPostalCode = function(postalCode)
{
   var validFormat = /^(\d{5}(-\d{4})?|[a-z]{1,2}[\da-z]{1,2} ?\d[a-z][a-z])$/i;
   var isValid = validFormat.test(postalCode);
   return isValid;
}




Validate.prototype.isValidEmail = function(email)
{
   var validFormatRegExp = /^\w(\.?\w)*@\w(\.?[-\w])*\.([a-z]{3}(\.[a-z]{2})?|[a-z]{2}(\.[a-z]{2})?)$/i;
   var isValid = validFormatRegExp.test(email);
   return isValid;
}




Validate.prototype.isValidDate = function(day, month,year)
{
	var isValid = true;

	var enteredDate = new Date(day + " " + month + " " + year);
	if (enteredDate.getDate() != day)
	{
		isValid = false;
	}
	return isValid;
}

Validate.prototype.isValidDateOfBirth = function(day, month, year)
{
	var isValid = true;
	var nowDate = new Date();
	year = parseInt(year);
	dateOfBirth =  new Date(day + " " + month + " " + year);
	if (!this.isValidDate(day,month,year))
	{
		isValid = false;
	}
	else if (dateOfBirth > nowDate || (year + 140) < nowDate.getFullYear())
	{
		isValid = false;
	}
	
	return isValid;
}


Validate.prototype.isValidCreditCardExpiry = function(expiresMonth, expiresYear)
{
	var isValid = true;
	var nowDate = new Date();
	if (expiresMonth < (nowDate.getMonth() + 1) && expiresYear <= nowDate.getFullYear())
	{
		isValid = false;
	}
	else if (expiresYear < nowDate.getFullYear())
	{
		isValid = false;
	}
	
	
	return isValid;
}

Validate.prototype.isValidCreditCardNumber = function(cardNumber, cardType)
{
	var isValid = false;
	var ccCheckRegExp = /[^\d ]/;
	isValid = !ccCheckRegExp.test(cardNumber);

	if (isValid)
	{
		var cardNumbersOnly = cardNumber.replace(/ /g,"");
		var cardNumberLength = cardNumbersOnly.length;
		var lengthIsValid = false;
		var prefixIsValid = false;
		var prefixRegExp;
		
		switch(cardType)
		{
			case "mastercard":
				lengthIsValid = (cardNumberLength == 16);
				prefixRegExp = /^5[1-5]/;
				break;
			
			case "visa":
				lengthIsValid = (cardNumberLength == 16 || cardNumberLength == 13);
				prefixRegExp = /^4/;
				break;
				
			case "amex":
				lengthIsValid = (cardNumberLength == 15);
				prefixRegExp = /^3(?:4|7)/;
				break;
				
			default:
				prefixRegExp = /^$/;
				alert("Nieznany typ karty");
		}
		
		prefixIsValid = prefixRegExp.test(cardNumbersOnly);
		isValid = prefixIsValid && lengthIsValid;
	}
	


	if (isValid)
	{
		var numberProduct;
		var numberProductDigitIndex;
		var checkSumTotal = 0;

		for (digitCounter = cardNumberLength - 1; digitCounter > 0; digitCounter--)
		{
		
       	  checkSumTotal += parseInt(cardNumbersOnly.charAt(digitCounter));	
       	  digitCounter--;
       	  
       	  numberProduct = new String((cardNumbersOnly.charAt(digitCounter) * 2));
		  
		  for (	var productDigitCounter = 0; 
				productDigitCounter < numberProduct.length; 
				productDigitCounter++
		  	  )
		  {
			checkSumTotal += parseInt(numberProduct.charAt(productDigitCounter));
		  }
		  
	    }
		
	    isValid = (checkSumTotal % 10 == 0);
	
     }
	
		
	return isValid;
}





Validate.prototype.checkFormValid = function(theForm,theDocument)
{
	var isWholeFormValid = true;
	var isValid = true;
	var theElement;
	var isToBeValidatedElementRegExp = /(_Compulsory)|(_NotCompulsory)/i;
	var isCompulsoryRegExp = /(_Compulsory)/i;
	var validDataTypeRegExp = /_[a-zA-Z]+$/i;
	var invalidDataType;
	var elementName;
	var errorDivId;
	var isCompulsoryElement;
	var isToBeCheckedElement;
	var isTextBoxElement;
	
// Sprawdzamy wypenienie pl tekstowych i (lub) poprawno typw danych.
	for (var formElementCounter = 0; formElementCounter < theForm.length; formElementCounter++)
	{
		theElement = theForm.elements[formElementCounter];
		elementName = new String(theElement.name);

		isCompulsoryElement = isCompulsoryRegExp.test(elementName);
		
		isToBeValidatedElement = isToBeValidatedElementRegExp.test(elementName);
		
		if (isToBeValidatedElement)
		{
			errorDivId = new String(theElement.name);
			errorDivId = errorDivId.slice(3,errorDivId.indexOf("_")) + "Error";
			this.hideErrorDiv(errorDivId,theDocument);
					
			isTextBoxElement =  theElement.type == "text" || 
								theElement.type == "password" || 
								theElement.type == "file";
			
			if ( isTextBoxElement )
			{
				isValid = this.isTextElementValid(theElement,
												  theDocument,
												  validDataTypeRegExp,
												  isCompulsoryElement);
				
				if ( !isValid )
				{
					this.showErrorDiv(errorDivId,theDocument);
					theElement.focus();
					isWholeFormValid = false;
				}
			} //Sprawdza, czy zaznaczone zostay obowizkowe przyciski opcji
			else if (theElement.type == "radio")
			{

				if (isCompulsoryElement)
				{
					elementName = theElement.name;
					theElement = theForm.elements[theElement.name];
					isValid = this.isOneRadioButtonInGroupSelected(theElement);

					if (isValid == false)
					{
						this.showErrorDiv(errorDivId,theDocument);		
						isWholeFormValid = false;			
					}

					do 
					{
						formElementCounter++;
						theElement = theForm.elements[formElementCounter];
					}
					while (theElement.name == elementName && formElementCounter < theForm.length)
						
					formElementCounter--;
				}
			}
		}
	}

	return isWholeFormValid;
}

Validate.prototype.isTextElementValid = function(theElement,
												theDocument,
												validDataTypeRegExp, 
												isCompulsoryElement)
{

	var isValid = true;
	var validDataType;
	
	if (isCompulsoryElement && theElement.value == "")
	{
		isValid = false;	
	}
	else
	{				
		validDataTypeRegExp.exec(theElement.name);
		validDataType = new String(RegExp.lastMatch)
		validDataType = validDataType.toLowerCase();
		isValid = this.isElementDataValid(theElement.value,validDataType)
	}	
	
	return isValid;
}

Validate.prototype.isElementDataValid = function(elementValue, validDataType)
{
	var isValid = false;
	switch (validDataType)
	{

		case "_alphanumeric":
			isValid = this.isOnlyAlphaNumeric(elementValue);
			break;
	
		case "_alphabetic":
			isValid = this.isOnlyAlphabetic(elementValue);
			break;

		case "_numeric":
			isValid = this.isOnlyNumeric(elementValue);
			break;

		case "_integer":
			isValid = this.isValidInteger(elementValue);
			break;
			
		case "_floatingpoint":
			isValid = this.isValidFloatingPoint(elementValue);
			break;

		case "_age":
			isValid = isValidAge(elementValue);
			break;
			
		case "_password":
			isValid = isValidPassword(elementValue);
			break;

		case "_telephone":
			isValid = isValidTelephoneNum(elementValue);
			break;				
	
		case "_postcode":	
			isValid = this.isValidPostalCode(elementValue);
			break;
	
		case "_email":
			isValid = this.isValidEmail(elementValue);
			break;
			
		default:
			alert("Bd: Niezidentyfikowany typ danych elementu");
	}
			
	return isValid;
}



Validate.prototype.isOneRadioButtonInGroupSelected = function(theElement)
{

	var radioCounter;
	var isValid = false;
	for (radioCounter = theElement.length - 1; radioCounter >= 0; radioCounter--)
	{

		isValid = theElement[radioCounter].checked;
		if (isValid)
		{
			break;
		}
	}

	return isValid;

}


Validate.prototype.showErrorDiv = function (  errorDescripDivId, 
								theDocument)
{
  if (document.layers)
  {
 	theDocument.layers[errorDescripDivId].visibility = "visible";
  }
  else if (document.all)
  {
	theDocument.all(errorDescripDivId).style.visibility = "visible"
  }
  else
  {
    theDocument.getElementById(errorDescripDivId).style.visibility = "visible"
  }
}


Validate.prototype.hideErrorDiv = function (errorDescripDivId, theDocument)
{
  if (theDocument.layers)
  {
	theDocument.layers[errorDescripDivId].visibility = "hidden";
  }
  else if (document.all)
  {
	theDocument.all(errorDescripDivId).style.visibility = "hidden"
  }
  else
  {
 	theDocument.getElementById(errorDescripDivId).style.visibility = "hidden"	
  }
}
