// CookieToolkit.js

// Utwrz cookie
function writeCookie(cookieName, cookieValue, expires, domain, path, secureFlag)
{
   if (cookieName)
   {
      var cookieDetails = cookieName + "=" + escape(cookieValue);
      cookieDetails += (expires ? "; expires=" + 
         expires.toGMTString(): '');
      cookieDetails += (domain ? "; domain=" + domain: '');
      cookieDetails += (path ? "; path=" + path: '');
      cookieDetails += (secureFlag ? "; secure": '');
      document.cookie = cookieDetails;
   }
}


// Pozyskaj niezakodowan warto cookies
function readUnescapedCookie(cookieName)
   {
   var cookieValue = document.cookie;
   var cookieRegExp = new RegExp("\\b" + cookieName + "=([^;]*)");
   cookieValue = cookieRegExp.exec(cookieValue);

   if (cookieValue != null)
   {
      cookieValue = cookieValue[1];	
   }

   return cookieValue;
}


// Pozyskaj warto cookies
function readCookie(cookieName)
{
   cookieValue = readUnescapedCookie(cookieName)

   if (cookieValue != null)
   {
      cookieValue = unescape(cookieValue);
   }

   return cookieValue;
}


// Usuwa istniejce cookies
function deleteCookie(cookieName)
{
   var expiredDate = new Date();
   expiredDate.setMonth(-1);
   writeCookie(cookieName,"",expiredDate);
}


// Utwrz cookie i nadaj pojedyncz warto
function writeMultiValueCookie( cookieName, multiValueName, value, expires, domain, path, secureFlag)
{
   var cookieValue = readUnescapedCookie(cookieName);
   if (cookieValue)
   {
      var stripAttributeRegExp = new RegExp("(^|&)" + 
         multiValueName + "=[^&]*&?");
      cookieValue = cookieValue.replace(stripAttributeRegExp,"$1");
      if (cookieValue.length != 0)
      {
         cookieValue += "&";
      }
   }
   else
   {
      cookieValue = "";
   }
   cookieValue += multiValueName + "=" + escape(value);
   var cookieDetails = cookieName + "=" + cookieValue;
   cookieDetails += (expires ? "; expires=" + expires.toGMTString(): '');
   cookieDetails += (domain ? "; domain=" + domain: '');
   cookieDetails += (path ? "; path=" + path: '');
   cookieDetails += (secureFlag ? "; secure": '');
   document.cookie = cookieDetails;
}


// Pozyskaj pojedyncz warto przechowywan wewntrz cookie
function readMultiValueCookie(cookieName, multiValueName)
{
   var cookieValue = readUnescapedCookie(cookieName)
   var extractMultiValueCookieRegExp = new RegExp("\\b" + 
      multiValueName + "=([^;&]*)");
   cookieValue = extractMultiValueCookieRegExp.exec(cookieValue);

   if (cookieValue != null)
   {
      cookieValue = unescape(cookieValue[1]);	
   }

   return cookieValue;
}


// Usuwa pojedyncz warto przechowywan wewntrz cookie
function deleteMultiValueCookie(cookieName, multiValueName, expires, domain, path, secureFlag)
{
   var cookieValue = readUnescapedCookie(cookieName);
   if (cookieValue)
   {
      var stripAttributeRegExp = new RegExp("(^|&)" + 
         multiValueName + "=[^&]*&?");
      cookieValue = cookieValue.replace(stripAttributeRegExp,"$1");

      if (cookieValue.length != 0)
      {
         var cookieDetails = cookieName + "=" + cookieValue;
         cookieDetails += (expires ? "; expires=" + 
            expires.toGMTString(): '');
         cookieDetails += (domain ? "; domain=" + domain: '');
         cookieDetails += (path ? "; path=" + path: '');
         cookieDetails += (secureFlag ? "; secure": '');
         document.cookie = cookieDetails;
      }
      else
      {
         deleteCookie(cookieName);
      }
   }
}


// Zwraca wartos true, jeli przegldarka uytkownika obsuguje cookies i obsuga ta jest uruchomiona
function cookiesEnabled()
{
   var cookiesEnabled = window.navigator.cookieEnabled;

   if (!cookiesEnabled)
   {
      document.cookie = "cookiesEnabled=True";
      cookiesEnabled = new Boolean(document.cookie).valueOf();
   }

   return cookiesEnabled;
}
