<xsl:stylesheet 
   xmlns="http://www.w3.org/1999/html" version="1.0" 
   xmlns:xsl  ="http://www.w3.org/1999/XSL/Transform" 
   xmlns:o="http://infomesh.net/2001/order/" 
   xml:lang="en" >

<xsl:template match="/">
   <html xmlns="http://www.w3.org/1999/html">
    <head>
       <title>Your Order</title>
       <link rel="stylesheet" type="text/css" href="style.css" />
     </head>
     <body>
        <h1>Order</h1>
        <xsl:apply-templates/>
        <address>
           <a href="http://example.org/">example.org</a>
        </address>
     </body>
   </html>
</xsl:template>

<xsl:template match="//o:CustomerName">
 <h2>Customer Name</h2>
 <dl>
 <xsl:for-each select=".//o:FirstName">
   <dt>First Name</dt>
      <dd><xsl:value-of select="." /></dd>
 </xsl:for-each>
 <xsl:for-each select=".//o:LastName">
   <dt>Last Name</dt>
      <dd><xsl:value-of select="." /></dd>
 </xsl:for-each>
 </dl>
</xsl:template>

<xsl:template match="//o:Address">
 <h2>Customer Address</h2>
 <dl>
 <xsl:for-each select=".//o:Street">
   <dt>Street</dt>
      <dd><xsl:value-of select="." /></dd>
 </xsl:for-each>
 <xsl:for-each select=".//o:Town">
   <dt>Town</dt>
      <dd><xsl:value-of select="." /></dd>
 </xsl:for-each>
 <xsl:for-each select=".//o:State">
   <dt>State</dt>
      <dd><xsl:value-of select="." /></dd>
 </xsl:for-each>
 <xsl:for-each select=".//o:Country">
   <dt>Country</dt>
      <dd><xsl:value-of select="." /></dd>
 </xsl:for-each>
 </dl>
</xsl:template>

<xsl:template match="//o:Items">
<h2>Items</h2>
<xsl:apply-templates/>
</xsl:template>

<xsl:template match="//o:Item">
 <xsl:for-each select=".//o:Book">
   <h3>Book</h3>
<dl>
   <dt>ISBN</dt>
      <dd><xsl:value-of select="(@ISBN)"/></dd>
   <dt>Title</dt>
      <dd><xsl:value-of select="(@Title)"/></dd>
   <dt>Price</dt>
      <dd><xsl:value-of select="(.)" /></dd>
</dl>
 </xsl:for-each>
 <xsl:for-each select=".//o:CD">
   <h3>CD</h3>
<dl>
   <dt>Artist</dt>
      <dd><xsl:value-of select="(@Artist)"/></dd>
   <dt>Title</dt>
      <dd><xsl:value-of select="(@Title)"/></dd>
   <dt>Price</dt>
      <dd><xsl:value-of select="." /></dd>
</dl>
 </xsl:for-each>
</xsl:template>

<xsl:template match="//o:CreditCard">
 <h2>Credit Card</h2>
 <dl>
 <dt>Type</dt>
    <dd><xsl:value-of select="(@Type)"/></dd>
 <xsl:for-each select=".//o:Number">
   <dt>Number</dt>
      <dd><xsl:value-of select="." /></dd>
 </xsl:for-each>
 <xsl:for-each select=".//o:ExpiryDate">
   <dt>Expiry Date</dt>
      <dd><xsl:value-of select="." /></dd>
 </xsl:for-each>
 </dl>
</xsl:template>
</xsl:stylesheet>
