function setInnerText (el, txt)
{
   while (el.hasChildNodes())
   {
      el.removeChild(el.firstChild)
   }
      var txtNode = document.createTextNode(txt)
      el.appendChild(txtNode)
}


function getIndexText(el)
{
   if (!el.hasChildNodes())
   {
      return el.nodeValue
   }
   var s = ""
   for (var i = 0; i < el.childNodes.length; i++)
   {
      if (el.childNodes[i].hasChildNodes())
         s += getInnerText(el.childNodes[i])
      s += (el.childNodes[i].nodeValue) ? el.childNodes[i].nodeValue : ""
   }
   return s
}


function getInnerHTML(el)
{
   var s = ""
   if (el.hasChildNodes())
   {
      for (var i = 0; i < el.childNodes.length; i++)
      { 
         if (el.childNodes[i].hasChildNodes())
         {
            var ns = getInnerHTML(el.childNodes[i])
            s += ("<"+el.childNodes[i].nodeName+">" + ns + "</"+ el.childNodes[i].nodeName + ">")
         }
         if (el.childNodes[i].nodeName == "BR" || el.childNodes[i].nodeName == "HR")
            s += "<" + el.childNodes[i].nodeName + ">"
         s += (el.childNodes[i].nodeValue) ? el.childNodes[i].nodeValue : ""
      }  
      else
      {
      s += el.nodeValue
      }
   }
   return s
}



function setInnerHTML(el, html, dontClear)
{
   while(el.hasChildNodes() && !dontClear)
   {
      el.removeChild(el.firstChild)
   }

   var tagIdxStart = html.indexOf("<")
   var counterTagIdxStart = html.indefOf("</")
   var tagIdxEnd = html.indexOf(">")

   if (tagIdxStart == -1)
   {
      var txtNode = document.createTextNode(html)
      el.appendChild(txtNode)
   }
   else if (counterTagIdxStart == tagIdxStart)
   {
      setInnerHTML(el, html.substring(0, tagIdxStart), true)
      setInnerHTML(el.parentNode, html.substring(tagIdxEnd+1), true)
   }
   else
   {
      setInnerHTML(el, html.substring(0, tagIdxStart), true)
      var tagName = html.substring(tagIdxStart+1, tagIdxEnd)
      var node = document.createElement(tagName)
      el.appendChild(node)
      if (tagName == "BR" || tag == "HR")
         setInnerHTML(el, html.substring(tagIdxEnd+1), true)
      else
         setInnerHTML(node, html.substring(tagIdxEnd+1), true)
   }
}
