//Patch the Date object

if(!Date.prototype.toDateString )
	Date.prototype.toDateString = function (){
		var DOW = ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
		var Month = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
		return ( DOW[this.getDay()] + " " + Month[this.getMonth()] + " " +
				this.getDate() + " " + this.getFullYear() );
	};

if (!Date.prototype.toTimeString )
	Date.prototype.toTimeString = function (){
		var hours = parseInt(this.getTimezoneOffset()/60);
		var mins = Math.abs(this.getTimezoneOffset()) - Math.abs(hours * 60);
		var s = (hours < 0)? "-" : "+";
		hours = Math.abs(hours);
		
		var offset = s + twoDigit(hours) + twoDigit(mins);
		
		return (twoDigit(this.getHours()) + ":" + twoDigit(this.getMinutes()) + ":" +
				twoDigit(this.getSeconds()) + " " + offset );
		
		function twoDigit( num ){
			if( num < 10 ) return "0" + num;
			return "" + num;
		}
	}
if(!Date.prototype.toLocaleDateString )
	Date.prototype.toLocaleDateString = Date.prototype.toDateString;

if(!Date.prototype.toLocaleTimeString )
	Date.prototype.toLocaleTimeString = Date.prototype.toTimeString;

//  Date_toTimeDate()

//	This is a string convenience method to save some typing;
//	in the final version, we may wish to omit it and simply direct 
//	the user to include the String_utils.js file instead

String.prototype.contains=String_contains;

function String_contains(character)
{
	var value=false;

	value=this.indexOf(character)!=-1;

	return value;
}

//	This is the actual Date formatting function; it's modelled loosely on the PHP date()
//	function -- see http://www.php.net/manual/en/function.date.php for the original; note
//	that we have no need for the optional timestamp argument present in the PHP version,
//	since the Date object itself supplies this information. It should also be noted that
//	we've eliminated some of the arguments where these duplicate methods of Date that are
//	already present or where it was felt that there would not be much demand, e.g. "Swatch
//	Internet Time." We have also made some other changes to make this method's arguments
//	a little more consistent.

/*
		ARGUMENTS:

    a - "am" or "pm"
    A - "AM" or "PM"
    a/A omitted: 24-hour time
    
    d - day of the month, no zeroes (1-31)
    D - day of month, leading zeroes (01-31)
    
    h - hours, no leading zero
    H - hours with leading zero
    
    I - minutes (leading zeroes always included)
    
    m - month, numeric, no zero ("8")
    M - month, numeric, leading zero ("08")
    n - month, text, short ("Aug")
    N - month, text, long ("August")
    
    o - English ordinal suffix, textual, 2 characters; i.e. "th", "nd" [lowercase letter "O"] ("3rd")
    
    S - seconds (leading zeroes always shown)
    
    w - day of the week, short ("Fri")
    W - day of the week, long ("Friday")
    w/W omitted: no weekday is displayed
    
    y - 2-digit year ("01") [merely truncates 4-digit year]
    Y - 4-digit year ("2001")    
*/

/*

		USAGE:
		
		The arguments to this function are entered as a string with a space separating the time and date.
		Whatever separator is used within these groups is duplicated in the output.
		A space is inserted after each element in the date group except as noted following.
		Commas used within the date group will have an extra space inserted after them.		
		Within the date, the order of the arguments is duplicated.
		Omitted arguments are ignored except as indicated above.
		
		Typical example:
		myDate=new Date(); //	it's 9:20:30PM on Fri 03 August 2001 (just for example)
		myDate.toTimeDate("h:I:Sa W,Ndo,Y");
		//	output is "9:20:30pm Friday, August 3rd, 2001"
		myDate.toTimeDate("H.I D-m-y");
		//	output is "21.20 03-Aug-01"
		myDate.toTimeDate("Y-M-D");
		//	output is "2001-08-03"
*/

String.prototype.contains=String_contains;

function String_contains(aChar)
{
	return this.indexOf(aChar)!=-1;
}

String.prototype.isAlphaNumeric=String_isAlphaNumeric;

function String_isAlphaNumeric()
{
  return this.match(/[0-9a-zA-Z]/)!=null;
}


Date.prototype.toTimeDate=Date_toTimeDate;

function Date_toTimeDate(format)
{
	var output="";
	var uFormat=format.toUpperCase();
	var fORMAT=format.toLowerCase();
	
	var myTime="";
	var myDate="";
	
	var myHours,myMinutes,myAmPm;
	var mySeconds="";
	var myWeekDay,myDate,myMonth,myYear;
	
	var separator="";

	var myTimeFormat="";
	var myDateFormat="";
	
	var tIMEfORMAT="";
	var dATEfORMAT="";
	
	var shortDays=["Sun","Mon","Tue","Wed","Thu","Fri","Sat"];
	var longDays=["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"];
	
	var shortMonths=["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"];
	var longMonths=["January","February","March","April","May","June","July","August","September","October","November","December"];
	
	if(format.contains(" "))
	{
		myTimeFormat=format.split(" ")[0];
		myDateFormat=format.split(" ")[1];
	}
	else
	{
		if(uFormat.contains("H")||uFormat.contains("I")||uFormat.contains("S"))
			myTimeFormat=format;
		else
			myDateFormat=format;
	}
	
	if(myTimeFormat!="")
	{
		tIMEfORMAT=myTimeFormat.toUpperCase();
		if(tIMEfORMAT.contains("H"))
		{
			myHours=this.getHours();
			if(tIMEfORMAT.contains("A"))
			{
				if(myHours>12)
				{
					myHours-=12;
					myTime+=myTimeFormat.contains("a")?"pm":"PM";
				}
				else
					myTime+=myTimeFormat.contains("a")?"am":"AM";
			}
			if(myTimeFormat.contains("H")&&myHours<10)
					myHours="0"+myHours;
			separator=tIMEfORMAT.charAt(tIMEfORMAT.indexOf("H")+1);
			if(separator!=" "&&separator!="A")myHours+=separator;
		}
		if(tIMEfORMAT.contains("I"))
		{
			myMinutes=this.getMinutes();
			if(myMinutes<10)myMinutes="0"+myMinutes;
			separator=tIMEfORMAT.charAt(tIMEfORMAT.indexOf("I")+1);
			if(separator!=" "&&separator!="A")myMinutes+=separator;
		}
		if(tIMEfORMAT.contains("S"))
		{
			mySeconds=this.getSeconds();
			if(mySeconds<10)mySeconds="0"+mySeconds;
		}
		myTime=myHours+myMinutes+mySeconds+myTime+" ";
	}
	
	if(myDateFormat!="")
	{
    myDate="";
    var temp="";
    var myChar="";
    for(var i=0;i<myDateFormat.length;i++)
	  {
	    var prevChar=myChar;
	    myChar=myDateFormat.charAt(i);
	    var nextChar=i<format.length?myDateFormat.charAt(i+1):null;
			
			if(myChar.isAlphaNumeric())
			{
    		if(myChar=="d"||myChar=="D")
        	temp=this.getDate();
    		if(myChar=="d")
    			if(temp<10)
      			temp="0"+temp;

    		if(myChar=="m"||myChar=="M"||myChar=="n"||myChar=="N")
      		temp=this.getMonth();
    		if(myChar=="m"||myChar=="M")
      		temp++;
    		if(myChar=="M"&&temp<10)
      		temp="0"+temp;

    		if(myChar=="n")
      		temp=shortMonths[temp-0];
    		if(myChar=="N")
      		temp=longMonths[temp-0];

    		if(myChar=="o")
    		{
    			var d=this.getDate()+"";
      		switch( d.charAt( d.length-1) )
      		{
        		case "1":
          		temp+="st";
        		break;

        		case "2":
          		temp+="nd";
        		break;

        		case "3":
          		temp+="rd";
        		break;

        		default:
          		temp+="th";
        		break;
        	}
      	}

      if(myChar=="w"||myChar=="W")
        temp=this.getDay();
      if(myChar=="w")
        temp=shortDays[temp];
      if(myChar=="W")
        temp=longDays[temp];

      if(myChar=="y"||myChar=="Y")
        temp=this.getFullYear()+"";
      if(myChar=="y")
        temp=temp.substr(temp.length-2,temp.length-1);

			if(nextChar.isAlphaNumeric()&&nextChar!="o")
				temp+=" ";
    }
    else
     	temp=myChar;

    if(myChar==",")
    	temp+=" ";

	  myDate+=temp;
  	temp="";
    }
  }
  output=myTime+" "+myDate;
  return output;
}

//  Date_isLeapYear()

function Date_isLeapYear( intYear )
{ 
  return (intYear%400==0 ? true:
          (intYear%100==0 ? false:
	       (intYear%4==0 ? true:false )
          )
         );
}

//  Date_daysInMonth()

function Date_daysInMonth()
{
  switch( this.getMonth()+1 )
  {
    case 9:
    case 4:
    case 6:
    case 11:
      return 30;
      break;
    
    case 2:
      return (  ( this.getFullYear() ).isLeapYear() ? 29 : 28  );
      break;

    default:
      return 31;
      break;
  }
}

