//  Array_getRandomElement()

function Array_getRandomElement()
{
  return this[Math.ceil(Math.random()*this.length)];
}

//  Array_getMaximum()

function Array_getMaximum()
{
  var maximum=this[0];

  for(var i=this.length-1;i>0;i--)
    if(this[i]>maximum)
      maximum=this[i];

  return maximum;
}

//  Array_getMinimum()

function Array_getMinimum()
{
  var minimum=this[0];

  for(var i=this.length-1;i>0;i--)
    if(this[i]<minimum)
      minimum=this[i];

  return minimum;
}

//  Array_search

Array.prototype.search=Array_search;

function Array_search(find)
{
	for(var intIndex=this.length-1;intIndex>=0 && this[intIndex] != find;intIndex--)
	{
		;
	}

	return intIndex;
}

//  Array_binarySearch

Array.prototype.binarySearch=_binarySearch;

function Array_binarySearch(find)
{
	return this.binarySearchRecursive( find, 0, this.length - 1 );
}

//  Array_binarySearchRecursive;

Array.prototype.binarySearchRecursive=Array_binarySearchRecursive;

function Array_binarySearchRecursive(find,intLeft,intRight)
{
	if(intLeft>intRight)
		return -1;

	var intMedian=(intLeft+intRight)/2;
	if(find==this[intMedian])
		return intMedian;

	if(intLeft==intRight)
		return -1;

	if(find<this[intMedian])
		return this.binarySearchRecursive(find,intLeft,intMedian-1);

	return this.binarySearchRecursive(find,intMedian+1,intRight);
}


//  Array_push()

if(!Array.prototype.push||Array(6,6,6,6).push(4)!= 5)
  Array.prototype.push=Array_push;
function Array_push(items)
{
  for(var x=0;x<arguments.length;x++)
    this[this.length]=arguments[x];
  return this.length;
}

//  Array_pop()

if(!Array.prototype.pop)
  Array.prototype.pop=Array_pop;

function Array_pop()
{
  var old=this[this.length-1];
  delete this[this.length-1];
  this.length--;
  return old;
}

//  Array_splice()

if(!Array.prototype.splice)
  Array.prototype.splice=Array_splice;

function Array_splice(start,deleteCount,items)
{
  var results = new Array();
  //copy items to delete and store in return array
  for(var x=0; x<deleteCount; x++)
    results[x] = this[x + start];
  //shift all remaining elements down
  for(x=start; x<this.length - deleteCount; x++)
    this[x] = this[x + deleteCount];
  //remove elements from the end
  this.length -= deleteCount;
  if(arguments.length>2)
  {
    //make room for the provided items to be inserted
    for(x=this.length-1; x>= start; x--)
      this[x + deleteCount] = this[x];
    //insert the provided items
    for(x=0; x<deleteCount; x++)
      this[x + start] = arguments[x + 2];
  }
  return results;
}

//  Array_shift

if(!Array.prototype.shift)
  Array.prototype.shift=Array_shift;

function Array_shift()
{
  var old=this[0];
  for(var x=0;x<this.length-1;x++)
    this[x]=this[x+1];
  delete this[this.length-1];
  this.length--;
  return old;
}

//  Array_unshift()

if(!Array.prototype.unshift||Array(6,6,6,6).unshift(4)!=5)
	Array.prototype.unshift=Array_unshift;

function Array_unshift(items)
{
  //move items up the chain
  for(var x=this.length-1;x>=0;x--)
    this[x+arguments.length]=this[x];
  for(x=0;x<arguments.length;x++)
    this[x]=arguments[x];

  return this.length;
}

//  Array_toLocaleString()

if(!Array.prototype.toLocaleString )
	Array.prototype.toLocaleString = Array.prototype.toString;

//  Array_getSum()
	
function Array_getSum()
{
  var total=this[0];
  for(var i=1;i<this.length;i++)
    total+=this[i];
  return total;
}

//  Array_getAverage

function Array_getAverage()
{
  return this.getSum()/this.length;
}
