// clock.js
function Clock(display)
{
   //Zmienne prywatne
   var clockFace = true
   var timeDisplayEl

   //Metody publiczne
   this.displayTime = function()
   {
      timeDisplayEl.nodeValue = this.getTime()
   }

   this.getDate = function()
   {
      var d = new Date()
      var yr = d.getFullYear()
      var today = (this.daysOfWeek[d.getDay()] + ", "
         + d.getDate() + " "
         + this.monthsOfYear[d.getMonth()] 
      // + this.dayNumberString(d.getDate()) 
         + " " + yr + "r.")
      return today
   }

   this.getTime = function()
   {
      var d = new Date()
      var hours = d.getHours()
      var minutes = d.getMinutes()
      var seconds = d.getSeconds()
      var timeValue = ""

      if (clockFace)
         timeValue = ((hours > 12) ? (hours - 12) : hours)
      else
         timeValue += ((hours < 10) ? "0" : "") + hours
         timeValue += ((minutes < 10) ? ":0" : ":") + minutes
         timeValue += ((seconds < 10) ? ":0" : ":") + seconds
   // if (clockFace)
   //    timeValue += ((hours >= 12) ? " P.M." : " A.M")
      return timeValue
   }

   this.setClockFace = function() { clockFace = !clockFace }

   this.init = function()
   {
      var displayEl = document.getElementById(display)
      var dateNode = document.createElement("SPAN")
      dateNode.style.cursor = "default"
      var txtNode = document.createTextNode(this.getDate())
      dateNode.appendChild(txtNode)
      displayEl.appendChild(dateNode)
      var brNode = document.createElement("BR")
      displayEl.appendChild(brNode)

      var timeNode = document.createElement("SPAN")
      timeNode.style.fontSize = "medium"
      timeNode.style.fontFamily = "monospace"
      timeNode.onclick = this.setClockFace
      timeDisplayEl = document.createTextNode(this.getTime())
      timeNode.appendChild(timeDisplayEl)
      displayEl.appendChild(timeNode)
   }
   this.init()
}

var daysOfWeek = new Array("Niedziela", "Poniedziaek", "Wtorek", "roda", "Czwartek", "Pitek", "Sobota")
var monthsOfYear = new Array("stycze", "luty", "marzec", "kwiecie", "maj", "czerwiec", "lipiec", "sierpie", "wrzesie", "padziernik", "listopad", "grudzie")

function dayNumberString(dayNumber)
{
   switch(dayNumber)
   {
      case 1:
      case 21:
      case 31:
         return "st"
      case 2:
      case 22:
         return "nd"
      case 3:
      case 23:
         return "rd"
      default:
         return "th"
   }
}

Clock.prototype.daysOfWeek = daysOfWeek
Clock.prototype. monthsOfYear = monthsOfYear
Clock.prototype.dayNumberString = dayNumberString
