function getInnerText(el) {
	if (!el.hasChildNodes()) return el.nodeValue
	var s = ""
	for (var i = 0; i < el.childNodes.length; i++) {
		if (el.childNodes[i].hasChildNodes())
			s += getInnerText(el.childNodes[i])
		s += (el.childNodes[i].nodeValue) ? el.childNodes[i].nodeValue : ""
	}
	return s
}

function setInnerText(el, txt) {
      while (el.hasChildNodes()) {
	 var node = el.firstChild
         el.removeChild(node)
      }
      var txtNode = document.createTextNode(txt)
      el.appendChild(txtNode)
}

//Remove the commented lines to turn this function into a getOuterHTML() function
//analagous to the the outerHTML property of elements in Internet Explorer
function getInnerHTML(el) {
	var s = ""
//	s += "<"+el.nodeName+">"
	if (el.hasChildNodes()) {
		for (var i = 0; i < el.childNodes.length; i++) {
			if (el.childNodes[i].hasChildNodes()) {
				var ns = getInnerHTML(el.childNodes[i])
				s += ("<"+el.childNodes[i].nodeName+">" + ns + "</"+el.childNodes[i].nodeName+">")
			}
			if (el.childNodes[i].nodeName == "BR" ||
			    el.childNodes[i].nodeName == "HR" ||
			    el.childNodes[i].nodeName == "LI")
				s += "<" + el.childNodes[i].nodeName + ">"
			s +=  (el.childNodes[i].nodeValue) ? el.childNodes[i].nodeValue : ""
		}
	} else {
		s += el.nodeValue
	}
//	s += "</" + el.nodeName + ">"
	return s
}

function setInnerHTML(el, html, dontClear) {
	while (el.hasChildNodes() && !dontClear) {
		el.removeChild(el.firstChild)
	}

	if (html.length == 0) return
	var tagIdxStart = html.indexOf("<")
	var counterTagIdxStart = html.indexOf("</")
	var tagIdxEnd = html.indexOf(">")

	if (tagIdxStart == -1) {
		var txtNode = document.createTextNode(html)
		el.appendChild(txtNode)
	} else if (counterTagIdxStart == tagIdxStart) {
		setInnerHTML(el, html.substring(0, tagIdxStart), true)
		setInnerHTML(el.parentNode, html.substring(tagIdxEnd+1), true)
	} else {
		setInnerHTML(el, html.substring(0, tagIdxStart), true)
		var tag = html.substring(tagIdxStart+1, tagIdxEnd)
		var node = document.createElement(tag)
		el.appendChild(node)
		if (tag == "BR" || tag == "HR")
			setInnerHTML(el, html.substring(tagIdxEnd+1), true)
		else	setInnerHTML(node, html.substring(tagIdxEnd+1), true)
	}
}
