/**
 * Logger.h
 *
 * Definicja prawdziwej klasy singleton dla dziennika.
 */
#include <iostream>
#include <fstream>
#include <vector>

class Logger
{
 public:
  static const std::string kLogLevelDebug;
  static const std::string kLogLevelInfo;
  static const std::string kLogLevelError;

  // Zwraca referencj do obiektu Logger bdcego singletonem.
  static Logger& instance();

  // Rejestruje jeden komunikat o podanym poziomie.
  void log(const std::string& inMessage, 
       const std::string& inLogLevel);

  // Rejestuje wektor komunikatw o podanym poziomie.
  void log(const std::vector<std::string>& inMessages, 
       const std::string& inLogLevel);

 protected:
  // Zmienna statyczna dla jedynego obiektu.
  static Logger sInstance;

  // Staa dla nazwy pliku.
  static const char* const kLogFileName;

  // Zmienna dla strumienia wyjciowego.
  std::ofstream mOutputStream;

 private:
  Logger();
  ~Logger();

};
