// ParsedXMLElement.h

#include <string>
#include <vector>

#include <xercesc/util/PlatformUtils.hpp>
#include <xercesc/parsers/XercesDOMParser.hpp>
#include <xercesc/dom/DOM.hpp>

XERCES_CPP_NAMESPACE_USE

/**
 * Uwaga: Jeeli zostanie usunity element korzenia, podelementy 
 * zostan uniewanione.
 */
class ParsedXMLElement
{
 public:
  ParsedXMLElement(const std::string& inFilename);
  ~ParsedXMLElement();

  std::string getName() const;
  std::string getTextData() const;
  std::string getAttributeValue(const std::string& inKey) const;
  // Wywoujcy jest odpowiedzialny za zwonienie obiektw ParsedXMLElements
  // na ktre wskazuj elementy wektora.
  std::vector<ParsedXMLElement*> getSubElements() const;

 protected:
  // Ten konstruktor jest uywany wewntrznie do tworzenia podelementw.
  ParsedXMLElement(DOMElement* inElement);

  XercesDOMParser* mParser;
  DOMElement*      mElement;
  static int       sReferences;

 private:
  // Wyaczenie konstruktora kopiujacego i operacji =.
  ParsedXMLElement(const ParsedXMLElement&);
  ParsedXMLElement& operator=(const ParsedXMLElement& rhs);
};
