#include "ParsedXMLElement.h"

#include <xercesc/util/XMLString.hpp>

#include <iostream>

XERCES_CPP_NAMESPACE_USE
using namespace std;

// Domylnie brak referencji
int ParsedXMLElement::sReferences = 0;

ParsedXMLElement::ParsedXMLElement(const std::string& inFilename)
{
  if (sReferences == 0) {
    // Pierwszy element -- inicjalizacja biblioteki.
    XMLPlatformUtils::Initialize();
  }
  sReferences++;

  mParser = new XercesDOMParser();
  mParser->parse(inFilename.c_str());

  DOMNode* node = mParser->getDocument();
  DOMDocument* document = dynamic_cast<DOMDocument*>(node);
  if (document == NULL) {
    cerr << "UWAGA: To nie jest dokument XML!" << endl;
    return;
  }

  mElement = dynamic_cast<const DOMElement*>(document->getDocumentElement());
  if (mElement == NULL) {
    cerr << "UWAGA: Dokument XML nie ma korzenia!" << endl;
  }
}

ParsedXMLElement::~ParsedXMLElement()
{
  if (mParser != NULL) {
    // To jest element korzenia.
    delete mParser;

    sReferences--;
    if (sReferences == 0) {
      // Usunity ostatni element
      XMLPlatformUtils::Terminate();
    }
  }
}

string ParsedXMLElement::getName() const
{
  char* tagName = XMLString::transcode(mElement->getTagName());
  string result(tagName);
  XMLString::release(&tagName);

  return result;
}

string ParsedXMLElement::getTextData() const
{
  // Zakadamy, e pierszy wze tekstowy jest tym, ktrego szukamy.
  DOMNodeList* children = mElement->getChildNodes();
  for (int i = 0; i < children->getLength(); i++) {
    DOMText* textNode = dynamic_cast<DOMText*>(children->item(i));
    if (textNode != NULL) {
      char* textData = XMLString::transcode(textNode->getData());
      string result(textData);
      XMLString::release(&textData);
      return result;
    }
  }

  // Nie znaleziono wzw tekstowych.
  return "";
}

string ParsedXMLElement::getAttributeValue(const std::string& inKey) const
{
  XMLCh* key = XMLString::transcode(inKey.c_str());

  const XMLCh* value = mElement->getAttribute(key);
  XMLString::release(&key);

  char* valueString = XMLString::transcode(value);
  string result(valueString);
  XMLString::release(&valueString);

  return result;
}

vector<ParsedXMLElement*> ParsedXMLElement::getSubElements() const
{
  vector<ParsedXMLElement*> result;

  DOMNodeList* children = mElement->getChildNodes();
  for (int i = 0; i < children->getLength(); i++) {
    DOMElement* elNode = dynamic_cast<DOMElement*>(children->item(i));
    if (elNode != NULL) {
      result.push_back(new ParsedXMLElement(elNode));
    }
  }

  return result;
}

ParsedXMLElement::ParsedXMLElement(DOMElement* inElement)
{
  mParser = NULL; // Brak parsera dla podelementu
  mElement = inElement;
} 

int main(int argc, char** argv)
{
  ParsedXMLElement e("test.xml");
  cout << "nazwa korzenia: " << e.getName() << endl;

  vector<ParsedXMLElement*> subelements = e.getSubElements();
  for (vector<ParsedXMLElement*>::iterator it = subelements.begin();
       it != subelements.end(); ++it) {
    cout << "nazwa podelementu: " << (*it)->getName() << endl;
    cout << "podelement speaker: " << (*it)->getAttributeValue("speaker") 
     << endl;
    cout << "dane tekstowe podelementu: " << (*it)->getTextData() << endl;
  }

  for (vector<ParsedXMLElement*>::iterator it = subelements.begin();
       it != subelements.end(); ++it) {
    delete *it;
  }

  return 0;
}
