#include "CarFactory.h"
#include <vector>

using namespace std;

CarFactory* getLeastBusyFactory(const vector<CarFactory*>& inFactories)
{
  if (inFactories.size() == 0) return NULL;

  CarFactory* bestSoFar = inFactories[0];


  for (size_t i = 1; i < inFactories.size(); i++)
    {
      if (inFactories[i]->getNumCarsInProduction() <
      bestSoFar->getNumCarsInProduction()) {
    bestSoFar = inFactories[i];
      }
    }

  return bestSoFar;
}

int main(int argc, char** argv)
{
  vector<CarFactory*> factories;

  // Tworzenie 3 fabryk Forda i 1 fabryki Toyoty.
  FordFactory* factory1 = new FordFactory();
  FordFactory* factory2 = new FordFactory();
  FordFactory* factory3 = new FordFactory();
  ToyotaFactory* factory4 = new ToyotaFactory();

  // Aby otrzym bardziej interesuje wyniki, wstpnie zamwimy kilka samochodw.
  factory1->requestCar();
  factory1->requestCar();
  factory2->requestCar();
  factory4->requestCar();

  // Dodanie fabryk do wektora.
  factories.push_back(factory1);
  factories.push_back(factory2);
  factories.push_back(factory3);
  factories.push_back(factory4);

  // Zbudowanie 10 samochodw w najmniej obcionej fabryce.
  for (int i = 0; i < 10; i++) {
    CarFactory* currentFactory = getLeastBusyFactory(factories);
    Car* theCar = currentFactory->requestCar();
    theCar->info();
  }
}
