/**
 * CarFactory.h
 */

// W tym przykadzie zakadamy, e klasa Car ju istnieje.
#include "Car.h"

class CarFactory
{
 public:
  CarFactory();

  Car* requestCar();

  int getNumCarsInProduction() const;

 protected:
  virtual Car* createCar() = 0;

 private:
  int mNumCarsInProduction;
};

class FordFactory : public CarFactory
{
 protected:
  virtual Car* createCar();
};

class ToyotaFactory : public CarFactory
{
 protected:
  virtual Car* createCar();
};
