#include <xercesc/util/PlatformUtils.hpp>

#include <xercesc/dom/DOM.hpp>
#include <xercesc/parsers/XercesDOMParser.hpp>
#include <xercesc/util/XMLString.hpp>

#include <iostream>

XERCES_CPP_NAMESPACE_USE
using namespace std;

void printNode(const DOMNode* inNode);

int main()
{
  XMLPlatformUtils::Initialize();

  XercesDOMParser* parser = new XercesDOMParser();
  parser->parse("test.xml");

  DOMNode* node = parser->getDocument();
  DOMDocument* document = dynamic_cast<DOMDocument*>(node);
  printNode(document->getDocumentElement());

  delete parser;
  XMLPlatformUtils::Terminate();
}

void printNode(const DOMNode* inNode)
{
  try {
    const DOMText& textNode = dynamic_cast<const DOMText&>(*inNode);
    char* text = XMLString::transcode(textNode.getData());
    cout << "Znaleziono dane tekstowe: " << text << endl;
    XMLString::release(&text);
  } catch (bad_cast) {
    // to nie jest wze tekstowy..
  }

  try {
    const DOMElement& elementNode = dynamic_cast<const DOMElement&>(*inNode);
    char* tagName = XMLString::transcode(elementNode.getTagName());
    cout << "Znaleziono znacznik o nazwie: " << tagName << endl;
    XMLString::release(&tagName);

    // Przegldanie listy atrybutw
    DOMNamedNodeMap* attributes = elementNode.getAttributes();
    for (int i = 0; i < attributes->getLength(); i++) {
      try {
    const DOMAttr& attrNode = dynamic_cast<const DOMAttr&>(*attributes->item(i));
    char* name = XMLString::transcode(attrNode.getName());
    char* value = XMLString::transcode(attrNode.getValue());
    cout << "Znaleziono par atrybutw: (" << name << "=" << value << ")" << endl;
    XMLString::release(&name);
    XMLString::release(&value);
      } catch (bad_cast) {
    cerr << "Na licie atrybutw znaleziono wze nie bdcy atrybutem!" << endl;
      }
    }
  } catch (bad_cast) {
    // to nie jest wze elementu...
  }

  // wywietlanie dowolnych podelementw
  DOMNodeList* children = inNode->getChildNodes();
  for (int i = 0; i < children->getLength(); i++) {
    printNode(children->item(i));
  }
  
}
