#include "XMLElement.h"

using namespace std;

XMLElement::XMLElement() : mElementName("unnamed"),  mTextNode("")
{
}

XMLElement::~XMLElement()
{
}

void XMLElement::setElementName(const string& inName)
{
  mElementName = inName;
}

void XMLElement::setAttribute(const string& inAttributeName, 
                  const string& inAttributeValue)
{
  // ustawienie pary klucz-warto, zastpujace istniejc par o ile istnieje
  mAttributes[inAttributeName] = inAttributeValue;
}

void XMLElement::addSubElement(const XMLElement* inElement)
{
  // dodanie nowego elementu do wektora podelementw
  mSubElements.push_back(inElement);
}

void XMLElement::setTextNode(const string& inValue)
{
  mTextNode = inValue;
}

ostream& operator<<(ostream& outStream, const XMLElement& inElem)
{
  inElem.writeToStream(outStream);
  return (outStream);
}


void XMLElement::writeToStream(ostream& outStream, int inIndentLevel) const
{
  indentStream(outStream, inIndentLevel);
  outStream << "<" << mElementName;  // otwarcie znacznika pocztkowego
  
  // zapisanie atrybutw
  for (map<string, string>::const_iterator it = mAttributes.begin();
       it != mAttributes.end(); ++it) {
    outStream << " " << it->first << "=\"" << it->second << "\"";
  }

  // zamknicie znacznika pocztkowego
  outStream << ">";

  if (mTextNode != "") {
    // jeeli jest tu wze tekstowy, wypisz go
    outStream << mTextNode;
  } else {
    outStream << endl;
    // wywoanie writeToStream na inIndentLevel+1 dla wszystkich podelementw
    for (vector<const XMLElement*>::const_iterator it = mSubElements.begin();
     it != mSubElements.end(); ++it) {
      (*it)->writeToStream(outStream, inIndentLevel + 1);
    }
    indentStream(outStream, inIndentLevel);
  }

  // zapis znacznika zamykajcego
  outStream << "</" << mElementName << ">" << endl;
}

void XMLElement::indentStream(ostream& outStream, int inIndentLevel) const
{
  for (int i = 0; i < inIndentLevel; i++) {
    outStream << "\t";
  }
}


int main()
{
  XMLElement dialogueElement;
  dialogueElement.setElementName("dialogue");
  
  XMLElement sentenceElement1;
  sentenceElement1.setElementName("sentence");
  sentenceElement1.setAttribute("speaker", "Maria");
  sentenceElement1.setTextNode("Chodmy na lody.");

  XMLElement sentenceElement2;
  sentenceElement2.setElementName("sentence");
  sentenceElement2.setAttribute("speaker", "Stefan");
  sentenceElement2.setTextNode("Dopiero jak skocz t ksik o C++.");

  // Dodanie elementw sentence jako podelementw elementu dialogue.
  dialogueElement.addSubElement(&sentenceElement1);
  dialogueElement.addSubElement(&sentenceElement2);

  // Wysanie elementu dialogue do stdout.
  cout << dialogueElement;
}

