#include "database.hh"
#include <iostream>
#include <fstream>
using namespace std;

const char* objRefFile = "OBJ_REF_FILE.dat";

int main(int argc, char** argv)
{
  // Prba inicjalizacji obiektu orb
  CORBA::ORB_var orb;
  try {
    orb = CORBA::ORB_init(argc, argv);
  } catch(CORBA::SystemException&) {
    cerr << "Nie mona zainicjowa obiektu ORB\n";
    exit(1);
  }

  // Read the server object reference from the file
  ifstream istr(objRefFile);
  if (istr.fail()) {
    cerr << "Brak pliku referencji obiektu!\n";
    exit(1);
  }
  char objRef[1024];
  istr.getline(objRef, 1024);

  // Tworzenie referencji obiektu na podstawie cigu 
  database_var dbref;
  try {
    CORBA::Object_var obj = orb->string_to_object(objRef);
    dbref = database::_narrow(obj);
    if(CORBA::is_nil(dbref) ) {
      cerr << "Nie mona ograniczy referencji do typu bazy danych\n";
      exit (1);
    }
  } catch(CORBA::SystemException&) {
    cerr << "Nie mona znale referencji obiektu\n";
  }

  // Wykonanie wywoa na podstawie referencji obiektu, ktre s tumaczone na
  // wywoania w obiekcie serwera w procesie serwera.
  try { 
    dbref->addRecord("key1", "value1");
    const char* lookup = dbref->lookupRecord("key1");
    if (strcmp(lookup, "value1") == 0) {
      cout << "Sukces!\n";
    } else {
      cout << "cigi nie pasuj\n";
    }
  }
  catch(CORBA::COMM_FAILURE& ex) {
    cerr << "Bd komunikacji\n";
    exit(1);
  } catch(CORBA::SystemException&) {
    cerr << "Bd komunikacji (SystemException)\n";
    exit(1);
  }

  // Gotowe
  orb->destroy();

  return (0);
}
