#include <vector>
#include <iostream>
#include <functional>
#include <algorithm>
using namespace std;

template <typename InputIterator, typename Predicate>
vector<InputIterator>
find_all(InputIterator first, InputIterator last, Predicate pred)
{
  vector<InputIterator> res;

  while (true) {
    // wyszukanie pierwszego dopasoania w biecym zakresie
    first = find_if(first, last, pred);
    // Sprawdzenie, czy find_if znalaz dopasowanie
    if (first == last) {
      break;
    }
    // Zapamietanie elementu.
    res.push_back(first);
    // Przesunicie zakresu pocztkowego do nastpnego elementu po znalezionym
    ++first;
  }
  return (res);
}

int main(int argc, char** argv)
{
    int arr[] = {3, 4, 5, 4, 5, 6, 5, 8};
    vector<int*> all = find_all(arr, arr + 8, bind2nd(equal_to<int>(), 5));

    cout << "Znaleziono " << all.size() << " pasujcych elementw: ";

    for (vector<int*>::iterator it = all.begin(); it != all.end(); ++it) {
        cout << **it << " ";
    }
    cout << endl;

    return (0);
}
