#include <algorithm>
#include <functional>
#include <iterator>
#include <vector>
#include <iostream>

using namespace std;

// Szablon funkcji wypeniajcej kontener liczb int.
// Kontener musi obsugiwa metod push_back().
template<typename Container>
void populateContainer(Container& cont)
{
  int num;

  while (true) {
    cout << "Podaj liczb do zapamitania (0 aby zatrzyma): ";
    cin >> num;
    if (num == 0) {
      break;
    }
    cont.push_back(num);
  }
}

int main(int argc, char** argv)
{
  vector<int> vectorOne, vectorTwo;
  populateContainer(vectorOne);

  back_insert_iterator<vector<int> > inserter(vectorTwo);
  remove_copy_if(vectorOne.begin(), vectorOne.end(), inserter,
         bind2nd(equal_to<int>(), 100));

  copy(vectorTwo.begin(), vectorTwo.end(), ostream_iterator<int>(cout, " "));
  cout << endl;

  return (0);
}
