#include <vector>
#include <list>
#include <stdexcept>
using namespace std;

// Kada klasa Hash musi posiada dwie metody: hash() oraz numBuckets().
template <typename T>
class DefaultHash
{
 public:
  // zgasza wyjtek invalid_argument jeeli numBuckets nie jest dodatnia
  DefaultHash(int numBuckets = 101) throw (invalid_argument);
  int hash(const T& key) const;
  int numBuckets() const { return mNumBuckets; }

 protected:
  int mNumBuckets;
};

// Specjalizacja dla typu string
template <>
class DefaultHash<string>
{
 public:
  // zgasza wyjtek invalid_argument jeeli numBuckets nie jest dodatnia
  DefaultHash(int numBuckets = 101) throw (invalid_argument);
  int hash(const string& key) const;
  int numBuckets() const { return mNumBuckets; }

 protected:
  int mNumBuckets;
};

template <typename Key, typename T, typename Compare = std::equal_to<Key>,
    typename Hash = DefaultHash<Key> >
class hashmap
{
public:
  typedef Key key_type;
  typedef T mapped_type;
  typedef pair<const Key, T> value_type;

  // Konstruktor
  // zgasza wyjtek invalid_argument jeeli obiekt hash zawiera niedodatni
  // liczb kubekw.
  explicit hashmap(const Compare& comp = Compare(),
           const Hash& hash = Hash()) throw(invalid_argument);

  // destruktor, konstruktr kopiujcy i operator przypisania
  ~hashmap();
  hashmap(const hashmap<Key, T, Compare, Hash>& src);
  hashmap<Key, T, Compare, Hash>& operator=(const hashmap<
                        Key, T, Compare, Hash>& rhs);

  // Wstawianie elementu.
  // Wstawia do kontenera par klucz-warto.
  void insert(const value_type& x);

  // Usuwanie elementu.
  // Jeeli istnieje element o kluczu x, usuwa go z kontenera.
void erase(const key_type& x);

  // Wyszukiwanie elementu.
  // Zwraca wskanik do elementu o kluczu x.
  // Zwraca NULL jeeli nie istnieje element o takim kluczu.
value_type* find(const key_type& x);

  // operator[] szuka elementu o kluczu x i wstawia element o takim kluczu
  // jeeli wczeniej nie istnia. Zwraca referencj do wartoci
  // reprezentowanej przez klucz.
  T& operator[] (const key_type& x);

protected:
typename list<pair<const Key, T> >::iterator
findElement(const key_type& x, int& bucket) const;

  typedef list<value_type> ListType;

  // W tej pierwszej implementacji atwiej uy wektora
  // zamiast wskanika do wektora, ktry wymaga dynamicznego tworzenia.
  // Jednak uyjemy wskanika do wektora, dziki czemu w ostatecznej
  // implementacji metoda swap() bdzie moga dziaa w staym czasie.
  vector<ListType>* mElems;
  int mSize;
  Compare mComp;
  Hash mHash;
};

#include "hashmap.cpp"
