#include <algorithm>
#include <iostream>
#include <vector>
using namespace std;

int main(int argc, char** argv)
{
  // Lista elementw do przeszukania
  int elems[] = {5, 6, 9, 8, 8, 3};

  // Tworzenie wektora na podstawie listy, korzystajc
  // z faktu, e wskaniki s rwnie iteratorami.
  vector<int> myVector(elems, elems + 6); 
  vector<int>::const_iterator it, it2;  

  // Wyszukanie mininalnego i maksymalnego elementu w wektorze.
  it = min_element(myVector.begin(), myVector.end());
  it2 = max_element(myVector.begin(), myVector.end());
  cout << "Minimum to " << *it << " a maksimum to " << *it2 << endl;

  // Znalezienie pierwszej pary kolejnych takich damych elementw.
  it = adjacent_find(myVector.begin(), myVector.end());
  if (it != myVector.end()) {
    cout << "Znaleziono dwa kolejne rwne sobie elementy o wartoci "
     << *it << endl;
  }

  // Wyszukanie pierwszej z dwch wartoci
  int targets[] = {8, 9};
  it = find_first_of(myVector.begin(), myVector.end(), targets,
             targets + 2);

  if (it != myVector.end()) {
    cout << "Znaleziono jedn z liczb 8 lub 9: " << *it << endl;
  }

  // Wyszukanie pierwszej sekwencji
  int sub[] = {8, 3};
  it = search(myVector.begin(), myVector.end(), sub, sub + 2);
  if (it != myVector.end()) {
    cout << "Znaleziono podsekwencj 8, 3 na pozycji " << it - myVector.begin()
     << endl;
  }

  // Wyszukanie ostatniej podsekwencji (powinna by ta sama co pierwsza)
  it2 = find_end(myVector.begin(), myVector.end(), sub, sub + 2);
  if (it != it2) {
    cout << "Bd: search i find_end znalazy rne podsekwencje "
     << " cho mamy tu tylko jeden taki przypadek.\n";
  }

  // Wyszukanie pierwszej podsekwencji dwch kolejnych semek
  it = search_n(myVector.begin(), myVector.end(), 2, 8);
  if (it != myVector.end()) {
    cout << "Znaleziono dwie kolejne semki zaczynajc od pozycji "
     << it - myVector.begin() << endl;
  }

  return (0);
}
