#include <algorithm>
#include <functional>
#include <vector>
#include <iostream>
using namespace std;

// Szablon funkcji do wypenienia kontenera liczb int
// Kontener musi obsugiwa push_back().
template<typename Container>
void populateContainer(Container& cont)
{
  int num;

  while (true) {
    cout << "Podaj liczb do zapamitania (0 aby zatrzyma): ";
    cin >> num;
    if (num == 0) {
      break;
    }
    cont.push_back(num);
  }
}

class MinAndMax : public unary_function<int, void>
{
public:
  MinAndMax();
  void operator()(int elem);

  // dla atwiejszego dostpu min i max s publiczne
  int min, max;

protected:
  bool first;
};

MinAndMax::MinAndMax() : min(-1), max(-1), first(true)
{
}

void MinAndMax::operator()(int elem)
{
  if (first) {
    min = max = elem;
  } else if (elem < min) {
    min = elem;
  } else if (elem > max) {
    max = elem;
  }
  first = false;
}

int main(int argc, char** argv)
{
  vector<int> myVector;
  populateContainer(myVector);

  MinAndMax func;
  func = for_each(myVector.begin(), myVector.end(), func);
  cout << "Maksimum wynosi " << func.max << endl;
  cout << "Minimum wynosi " << func.min << endl;

  return (0);
}
