#include <algorithm>
#include <vector>
#include <list>
#include <iostream>
using namespace std;

// Szablon funkcji do wypenienia kontenera liczb int
// Kontener musi obsugiwa push_back().
template<typename Container>
void populateContainer(Container& cont)
{
  int num;

  while (true) {
    cout << "Podaj liczb do zapamitania (0 aby zatrzyma): ";
    cin >> num;
    if (num == 0) {
      break;
    }
    cont.push_back(num);
  }
}

int main(int argc, char** argv)
{
  vector<int> myVector;
  list<int> myList;

  cout << "Wypenienie wektora:\n";
  populateContainer(myVector);
  cout << "Wypenienie listy:\n";
  populateContainer(myList);
  if (myList.size() < myVector.size()) {
    cout << "Bd, lista nie jest wystarczajco dua.\n";
    return (0);
  }

  // porwnanie dwch kontenerw
  if (equal(myVector.begin(), myVector.end(), myList.begin())) {
    cout << "Oba kontenery maj rwne elementy\n";
  } else {
    // Jeeli kontenery nie s rwne, sprawdzamy dlaczego
    pair<vector<int>::iterator, list<int>::iterator> miss =
      mismatch(myVector.begin(), myVector.end(), myList.begin());
    cout << "Pierwsza rnica znajduje si na pozycji "
     << miss.first - myVector.begin() << ". Wektor zawiera warto "
     << *(miss.first) << " natomiast lista zawiera warto " << *(miss.second)
     << endl;
  }

  // Teraz porzdkujemy kontenery
  if (lexicographical_compare(myVector.begin(), myVector.end(), myList.begin(),
                  myList.end())) {
    cout << "Leksykograficznie pierwszy jest wektor.\n";
  } else {
    cout << "Leksykograficznie pierwsza jest lista.\n";
  }

  return (0);
}
