#include <ostream>
#include <string>
#include <stack>
#include <stdexcept>

// Przykadowa klasa Error zawierajca tylko priorytet i opis bdu.
class Error
{
 public:
  Error(int priority, std::string errMsg) :
    mPriority(priority), mError(errMsg) {}
  int getPriority() const {return mPriority; }
  std::string getErrorString() const {return mError; }

  friend bool operator<(const Error& lhs, const Error& rhs);
  friend std::ostream& operator<<(std::ostream& str, const Error& err);

 protected:
  int mPriority;
  std::string mError;
};

// Prosta klasa ErrorCorrelator zwracajaca bdy o najwyszym priorytecie.
class ErrorCorrelator
{
 public:
  ErrorCorrelator() {}

  //
  // Dodanie bdu do skorelowania.
  //
  void addError(const Error& error);

  //
  // Odczytanie nastpnego bdu do przetworzenia.
  //
  Error getError() throw (std::out_of_range);

 protected:
  std::stack<Error> mErrors;

 private:
  // Uniemoliwienie przypisywania i przekazywania przez referencj.
  ErrorCorrelator(const ErrorCorrelator& src);
  ErrorCorrelator& operator=(const ErrorCorrelator& rhs);
};
