#include "CableCompany.h"
using namespace std;

void CableCompany::addPackage(const string& packageName,
                  const bitset<kNumChannels>& channels)
{
  // Utworzenie pary klucz-warto i wstawienie jej do kontenera packages.
  mPackages.insert(make_pair(packageName, channels));
}

void CableCompany::removePackage(const string& packageName)
{
  // Skasowanie pakietu z kontenera.
  mPackages.erase(packageName);
}

void CableCompany::newCustomer(const string& name, const string& package)
  throw (out_of_range)
{
  // Pobranie referencji do okrelonego pakietu.
  MapType::const_iterator it = mPackages.find(package);
  if (it == mPackages.end()) {
    // Pakiet nie istnieje, zgaszam wyjtek.
    throw (out_of_range("Niewaciwy pakiet"));
  } else {
    // Utworzenie konta z kontenerem bitset reprezentujcym ten pakiet.
    // Zwr uwag, e odwouje si do pary nazwa/bitset pair. 
    // bitset jest drugim polem.
    mCustomers.insert(make_pair(name, it->second));
  }
}

void CableCompany::newCustomer(const string& name,
                   const bitset<kNumChannels>& channels)
{
  // Dodaj par klient/kanay do kontenera klientw.
  mCustomers.insert(make_pair(name, channels));
}

void CableCompany::addChannel(const string& name, int channel)
{
  // Znajd referencj klienta.
  MapType::iterator it = mCustomers.find(name);
  if (it != mCustomers.end()) {
    // Znalelimy klienta; ustawiamy kana.
    // Zwr uwag, e jest to referencja do pary nazwa/bitset.
    // bitset jest drugim polem.
    it->second.set(channel);
  }
}

void CableCompany::removeChannel(const string& name, int channel)
{
  // Znajd referencj klienta.
  MapType::iterator it = mCustomers.find(name);
  if (it != mCustomers.end()) {
    // Znalelimy klienta; usuwamy kana.
    // Zwr uwag, e jest to referencja do pary nazwa/bitset.
    // bitset jest drugim polem.
    it->second.reset(channel);
  }
}

void CableCompany::addPackageToCustomer(const string& name, const string& package)
{
  // Znajd pakiet.
  MapType::iterator itPack = mPackages.find(package);
  // Znajd klienta.
  MapType::iterator itCust = mCustomers.find(name);
  if (itCust != mCustomers.end() && itPack != mPackages.end()) {
    // Aktualizaj wykonujemy jeeli znaleziony jest pakiet i klient.
    // Lub w pakiecie dla klienta istniej kanay.
    // Zwr uwag, e jest to referencja do pary nazwa/bitset.
    // bitset jest drugim polem.
    itCust->second |= itPack->second; 
  }
}

void CableCompany::deleteCustomer(const string& name)
{
  // Usuwanie klienta o podanej nazwie.
  mCustomers.erase(name);
}

bitset<kNumChannels>& CableCompany::getCustomerChannels(const string& name)
  throw (out_of_range)
{
  // Znajd klienta.
  MapType::iterator it = mCustomers.find(name);
  if (it != mCustomers.end()) {
    // Znaleziono!
    // Zwr uwag, e jest to referencja do pary nazwa/bitset.
    // bitset jest drugim polem.
    return (it->second);
  }
  // Nie znaleziono. Zgaszamy wyjtek.
  throw (out_of_range("Brak klienta o podanej nazwie"));
} 
