#include <map>
#include <string>
#include <list>

using std::multimap;
using std::string;
using std::list;

class BuddyList
{
 public:
  BuddyList();

  //
  // Dodaje znajomego dla danego uytkownika.
  //
  void addBuddy(const string& name, const string& buddy);

  //
  // Usuwa znajomego z listy danego uytkownika.
  //
  void removeBuddy(const string& name, const string& buddy);

  //
  // Zwraca true, jeeli buddy jest znajomym uzytkownika.
  // W przeciwnym razie zwraca false.
  //
  bool isBuddy(const string& name, const string& buddy) const;

  //
  // pobiera list wszystkich znajomych uytkownika.
  //
  list<string> getBuddies(const string& name) const;

 protected:
  multimap<string, string> mBuddies;
 private:
  // Uniemoliwienie przypisywania i przekazywania przez referencj.
  BuddyList(const BuddyList& src);
  BuddyList& operator=(const BuddyList& rhs);
};
