#include "BuddyList.h"
using namespace std;

BuddyList::BuddyList()
{
}

void BuddyList::addBuddy(const string& name, const string& buddy)
{
  // Upewnij si, e ten znajomy nie jest ju zarejestrowany.
  // Nie chcemy wstawia identycznych kopii par klucz-warto.
  if (!isBuddy(name, buddy)) {
    mBuddies.insert(make_pair(name, buddy));
  }
}

void BuddyList::removeBuddy(const string& name, const string& buddy)
{
  // Deklaracja dwch iteratorw map
  multimap<string, string>::iterator start, end;

  // Uzyskanie pocztku i koca zakresu elementw o podanej nazwie klucza.
  // Zastosowanie zarwno lower_bound() jak i upper_bound() w celu
  // zademonstrowania ich dziaania. Normalnie naley po prostu 
  // wywoa equal_range().
  start = mBuddies.lower_bound(name);
  end = mBuddies.upper_bound(name); 
  
  // Przegldanie elementw o podanej wartoci klucza i szukanie 
  // wartoci parametru buddy
  for (start; start != end; ++start) {
    if (start->second == buddy) {
      // Znalelimy odpowiedni element! Usuwany go z kontenera.
      mBuddies.erase(start);
      break;
    }
  }
}

bool BuddyList::isBuddy(const string& name, const string& buddy) const
{
  // Deklaracja dwch iteratorw map
  multimap<string, string>::const_iterator start, end;
  // Uzyskanie pocztku i koca zakresu elementw o podanej nazwie klucza.
  // Zastosowanie zarwno lower_bound() jak i upper_bound() w celu
  // zademonstrowania ich dziaania. Normalnie naley po prostu 
  // wywoa equal_range().
  start = mBuddies.lower_bound(name);
  end = mBuddies.upper_bound(name);

  // Przegldanie elementw o podanej wartoci klucza i szukanie 
  // wartoci parametru buddy. Jeeli nie ma elementw z podan wartoci 
  // klucza, zmienna start jest rwna end, wic ptla nie zostanie wykonana.
  for (start; start != end; ++start) {
    if (start->second == buddy) {
      // Znalelimy odpowiedni element!
      return (true);
    }
  }
  // Nie znaleziono
  return (false);
}

list<string> BuddyList::getBuddies(const string& name) const
{
  // Utworzenie zmiennej do zapamitania pary iteratorw.
  pair<multimap<string, string>::const_iterator,
    multimap<string, string>::const_iterator> its;

  // Uzyskanie pary iteratorw oznaczajcych zakres zawierajcy
  // elementy o podanej wartoci klucza.
  its = mBuddies.equal_range(name);

  // Utworzenie listy z wszystkimi nazwami w zakresie
  // (wszyscy znajomi uytkownika).
  list<string> buddies;
  for (its.first; its.first != its.second; ++its.first) {
    buddies.push_back((its.first)->second);
  }

  return (buddies);
}
