#include <vector>
#include <string>
#include <fstream>

using std::string;
using std::vector;
using std::ostream;

//
// klasa RingBuffer
//
// Zapewnia prosty bufor diagnostyczny. Klient okrela w konstruktorze liczb
// pozycji i dodje komunikaty za pomoc metody addEntry(). Gdy liczba
// pozycji przekroczy dozwolon, nowe pozycje bd nadpisyway stare.
//
// Bufor zapewnia moliwo wywietlania pozycji dodawanych do niego.
// Klient moe okreli w konstruktorze strumie wyjciowy
// i zmieni go za pomoc metody setOutput().
// 
// Bufor pozwala rwnie na wysanie zawartoci do strumienia wyjciowego.
//
class RingBuffer
{
 public:
  //
  // Tworzy bufor cykliczny z miejscem na numEntries pozycji.
  // Po dodaniu do bufora pozycje s zapisywane do *ostr.
  //
  RingBuffer(int numEntries = kDefaultNumEntries, ostream* ostr = NULL);
  ~RingBuffer();

  //
  // Dodaje cigi do bufora cyklicznego, by moe nadpisujc 
  // stare zapisy w buforze (dy bufor jest peny).
  //
  void addEntry(const string& entry);

  //
  // Wysya pozycje bufora, rozdzielane znakami nowego wiersza, do ostr.
  //
  friend ostream& operator<<(ostream& ostr, const RingBuffer& rb);

  //
  // Ustawia strumie wyjciowy do ktrego s kierowane dodawane pozycje.
  // Zwraca stary strumie wyjciowy.
  //
  ostream* setOutput(ostream* newOstr);

 protected:
  vector<string> mEntries;
  ostream* mOstr;
  
  int mNumEntries, mNext;
  bool mWrapped;

  static const int kDefaultNumEntries = 500;

 private:
  // Uniemoliwia przypisywanie i przekazywanie przez warto
  RingBuffer(const RingBuffer& src);
  RingBuffer& operator=(const RingBuffer& rhs);
};
