#include <algorithm>
#include <iterator>
#include <iostream>
#include "RingBuffer.h"

using namespace std;

// Microsoft Visual Studio wymaga pominicia tego wiersza.
// Inne kompilatory potrzebuj go.
//const int RingBuffer::kDefaultNumEntries;

//
// Inicjalizacja wektora mieszczcego dokadnie numEntries. Rozmiar wektora
// nie musi zmienia si w czasie korzystania z obiektu.
//
// Inicjalizacja pozostaych funkcji skadowych.
//
RingBuffer::RingBuffer(int numEntries, ostream* ostr) : mEntries(numEntries),
                       mOstr(ostr), mNumEntries(numEntries), mNext(0), mWrapped(false)
{
}

RingBuffer::~RingBuffer()
{
}

//
// Algorytm jest bardzo prosty: dodaj pozycj na nastpne wolne miejsce,
// nastpnie przesu mNext aby wskazywaa na nastpne wolne miejsce.
// Jeeli mNext osignie koniec wektora, rozpocznij znw od 0.
//
// Bufor musi pamita, czy elementy zostay zawinite czy nie
// aby zdecydowa, czy drukowa pozycje po mNext w operator<<.
//
void RingBuffer::addEntry(const string& entry)
{
  // Dodanie pozycji do nastpnej wolnej pozycji i zwikszenie zmiennej
  // mNext aby wskazywaa na nastpny wolny slot.
  mEntries[mNext++] = entry;

  // Sprawdzenie, czy osignlimy koniec bufora. Jeeli tak, musimy zawin.
  if (mNext >= mNumEntries) {
    mNext = 0;
    mWrapped = true;
  }

  // Jeeli zosta przypisany prawidowy ostream, zapisz do niego pozycj.
  if (mOstr != NULL) {
    *mOstr << entry << endl;
  }
}

ostream* RingBuffer::setOutput(ostream* newOstr)
{
  ostream* ret = mOstr;
  mOstr = newOstr;
  return (ret);
}

//
// Ta funkcja korzysta z ostream_iterator do "skopiowania" pozycji
// z wektora do strumienia wyjciowego.
//
// Funkcja ta musi drukowa elementy w kolejnoci. Jeeli bufor zosta
// zawinity, najwczeniejsz pozycj jest ta  o jeden wiksza ni bieca.
// Na pocztek wic drukujemy pozycje od mNext do koca.
//
// Nastpnie (nawet jeeli bufor nie zosta zawinity) drukowane s pozycje 
// od pocztku a do mNext - 1.
//
ostream& operator<<(ostream& ostr, const RingBuffer& rb)
{
  if (rb.mWrapped) {
    //
    // Jeeli bufor zosta zawinity, drukuj elementy od
    // najwczeniejszej pozycji do koca.
    //
    copy (rb.mEntries.begin() + rb.mNext, rb.mEntries.end(),
      ostream_iterator<string>(ostr, "\n"));
  }

  //
  // Teraz drukuj do najnowszej pozycji.
  // Przegldaj a do begin() + mNext, poniewa zakres nie jest zamknity 
  // z prawej strony.
  //
  copy (rb.mEntries.begin(), rb.mEntries.begin() + rb.mNext,
        ostream_iterator<string>(ostr, "\n"));

  return (ostr);
}
