#include "ArticleCitations.h"
#include <iostream>
#include <fstream>
#include <string>
#include <stdexcept>
using namespace std;

ArticleCitations::ArticleCitations(const string& fileName)
{
  // Musimy tylko odczyta plik
  readFile(fileName);
}

ArticleCitations::ArticleCitations(const ArticleCitations& src)
{
  // Kopiowanie nazwy artykuu, autora, itd..
  mArticle = src.mArticle;
  // Kopiowanie liczby cytowa
  mNumCitations = src.mNumCitations;
  // Utworzenie tablicy o waciwej wielkoci
  mCitations = new string[mNumCitations];
  // Kopiowanie kadego z elementw tablicy
  for (int i = 0; i < mNumCitations; i++) {
    mCitations[i] = src.mCitations[i];
  }
}

ArticleCitations& ArticleCitations::operator=(const ArticleCitations& rhs)
{
  // Sprawdzenie przypisania do samego siebie
  if (this == &rhs) {
    return (*this);
  }
  // Zwolnienie starej pamici
  delete [] mCitations;
  // Kopiowanie nazwy artykuu, autora, itd..
  mArticle = rhs.mArticle;
  // Kopiowanie liczby cytowa
  mNumCitations = rhs.mNumCitations;
  // Utworzenie tablicy o waciwej wielkoci
  mCitations = new string[mNumCitations];
  // Kopiowanie kadego cytatu
  for (int i = 0; i < mNumCitations; i++) {
    mCitations[i] = rhs.mCitations[i];
  }
  return (*this);
}

ArticleCitations::~ArticleCitations()
{
  delete [] mCitations;
}

void ArticleCitations::readFile(const string& fileName)
{
  // otwarcie pliku i kontrola poprawnoci
  ifstream istr(fileName.c_str());
  if (istr.fail()) {
    throw invalid_argument("Nie mona otworzy pliku\n");
  }
  // Odczyt wiersza z artykuem, autorem, tytuem, itd.
  getline(istr, mArticle);

  // pominicie odstpw przed rozpoczciem cytatu
  istr >> ws;

  int count = 0;
  // zapamitanie biecej pozycji, aby mona byo do niej wrci
  int citationsStart = istr.tellg();
  // Na pocztek zliczanie liczby cytowa
  while (!istr.eof()) {
    string temp;
    getline(istr, temp);
    // pominicie odstpw przed nastpn pozycj
    istr >> ws;
    count++;
  }

  if (count != 0) {
    // utworzenie tablicy cigw do zapamitania cytowa
    mCitations = new string[count];
    mNumCitations = count;
    // kasowanie poprzedniego znacznika eof
    istr.clear();
    // powrt na pocztek cytowa
    istr.seekg(citationsStart);
    // read each citation and store it in the new array
    for (count = 0; count < mNumCitations; count++) {
      string temp;
      getline(istr, temp);
      mCitations[count] = temp;
    }
  }
}
