#include "SpreadsheetCell.h"

#include <iostream>
#include <sstream>

using namespace std;

SpreadsheetCell::SpreadsheetCell() : mValue(0), mNumAccesses(0)
{
}

SpreadsheetCell::SpreadsheetCell(double initialValue) : mNumAccesses(0)
{
  set(initialValue);
}

SpreadsheetCell::SpreadsheetCell(const string& initialValue) :
  mValue(stringToDouble(initialValue)), mString(initialValue), mNumAccesses(0)
{
}

SpreadsheetCell::SpreadsheetCell(const SpreadsheetCell& src)
{
  mValue = src.mValue;
  mString = src.mString;
  mNumAccesses = src.mNumAccesses;
}

SpreadsheetCell& SpreadsheetCell::operator=(const SpreadsheetCell& rhs)
{
  if (this == &rhs) {
    return (*this);
  }
  mValue = rhs.mValue;
  mString = rhs.mString;
  mNumAccesses = rhs.mNumAccesses;
  return (*this);
}

void SpreadsheetCell::set(double inValue)
{
  mValue = inValue;
  mString = doubleToString(mValue);
}

void SpreadsheetCell::set(const string& inString)
{
  mString = inString;
  mValue = stringToDouble(mString);
}

string SpreadsheetCell::doubleToString(double inValue)
{
  ostringstream ostr;

  ostr << inValue;
  return (ostr.str());
}

double SpreadsheetCell::stringToDouble(const string& inString)
{
  double temp;

  istringstream istr(inString);

  istr >> temp;
  if (istr.fail() || !istr.eof()) {
    return (0);
  }
  return (temp);
}

const SpreadsheetCell operator+(const SpreadsheetCell& lhs,
				const SpreadsheetCell& rhs)
{
  SpreadsheetCell newCell;
  newCell.set(lhs.mValue + rhs.mValue); // wywoanie set w celu aktualizacji mValue i mString
  return (newCell);
}

const SpreadsheetCell operator-(const SpreadsheetCell& lhs,
				const SpreadsheetCell& rhs)
{
  SpreadsheetCell newCell;
  newCell.set(lhs.mValue - rhs.mValue); // wywoanie set w celu aktualizacji mValue i mString
  return (newCell);
}

const SpreadsheetCell operator*(const SpreadsheetCell& lhs,
				const SpreadsheetCell& rhs)
{
  SpreadsheetCell newCell;
  newCell.set(lhs.mValue * rhs.mValue); // wywoanie set w celu aktualizacji mValue i mString
  return (newCell);
}

const SpreadsheetCell operator/(const SpreadsheetCell& lhs,
				const SpreadsheetCell& rhs)
{
  SpreadsheetCell newCell;
  if (rhs.mValue == 0) {
    newCell.set(0); // wywoanie set w celu aktualizacji mValue i mString
  } else {
    newCell.set(lhs.mValue / rhs.mValue); // wywoanie set w celu aktualizacji mValue i mString
  }
  return (newCell);
}

SpreadsheetCell& SpreadsheetCell::operator+=(const SpreadsheetCell& rhs)
{
  set(mValue + rhs.mValue); // wywoanie set w celu aktualizacji mValue i mString
  return (*this);
}

SpreadsheetCell& SpreadsheetCell::operator-=(const SpreadsheetCell& rhs)
{
  set(mValue - rhs.mValue); // wywoanie set w celu aktualizacji mValue i mString
  return (*this);
}

SpreadsheetCell& SpreadsheetCell::operator*=(const SpreadsheetCell& rhs)
{
  set(mValue * rhs.mValue); // wywoanie set w celu aktualizacji mValue i mString
  return (*this);
}

SpreadsheetCell& SpreadsheetCell::operator/=(const SpreadsheetCell& rhs)
{
  set(mValue / rhs.mValue); // wywoanie set w celu aktualizacji mValue i mString
  return (*this);
}

bool operator==(const SpreadsheetCell& lhs, const SpreadsheetCell& rhs)
{
  return (lhs.mValue == rhs.mValue);
}

bool operator<(const SpreadsheetCell& lhs, const SpreadsheetCell& rhs)
{
  return (lhs.mValue < rhs.mValue);
}

bool operator>(const SpreadsheetCell& lhs, const SpreadsheetCell& rhs)
{
  return (lhs.mValue > rhs.mValue);
}

bool operator!=(const SpreadsheetCell& lhs, const SpreadsheetCell& rhs)
{
  return (lhs.mValue != rhs.mValue);
} 

bool operator<=(const SpreadsheetCell& lhs, const SpreadsheetCell& rhs)
{
  return (lhs.mValue <= rhs.mValue);
}

bool operator>=(const SpreadsheetCell& lhs, const SpreadsheetCell& rhs)
{
  return (lhs.mValue >= rhs.mValue);
}

const SpreadsheetCell SpreadsheetCell::operator-() const
{
  SpreadsheetCell newCell(*this);
  newCell.set(-mValue); // wywoanie set w celu aktualizacji mValue i mStr

  return (newCell);
}

SpreadsheetCell& SpreadsheetCell::operator++()
{
  set(mValue + 1);
  return (*this);
}

const SpreadsheetCell SpreadsheetCell::operator++(int)
{
  SpreadsheetCell oldCell(*this); // zapamitaj aktualn warto przed inkrementacj
  set(mValue + 1); // inkrementacja
  return (oldCell); // zwrcenie starej wartoci
}

SpreadsheetCell& SpreadsheetCell::operator--()
{
  set(mValue - 1);
  return (*this);
}

const SpreadsheetCell SpreadsheetCell::operator--(int)
{
  SpreadsheetCell oldCell(*this); // zapamitaj aktualn warto przed dekrementacj
  set(mValue - 1); // dekrementacja
  return (oldCell); // zwrcenie starej wartoc
}

ostream& operator<<(ostream& ostr, const SpreadsheetCell& cell)
{
  ostr << cell.mString;
  return (ostr);
}

istream& operator>>(istream& istr, SpreadsheetCell& cell)
{
  string temp;
  istr >> temp;
  cell.set(temp);
  return (istr);
}
