#include "Array.h"

#include <stdexcept>
using namespace std;

// Microsoft Visual Studio wymaga pominicia powyszego wiersza.
// Inne kompilatory go wymagaj.
//const int Array::kAllocSize;

Array::Array()
{
  mSize = kAllocSize;
  mElems = new int[mSize];
}

Array::~Array()
{
  delete [] mElems;
}

void Array::resize(int newSize)
{
  int* newElems = new int[newSize]; // Alokacja tablicy o nowym rozmiarze.

  // Nowy rozmiar jest zawsze wikszy od starego.
  for (int i = 0; i < newSize; i++) {
    // Kopiuj elementy ze starej tablicy do nowej.
    newElems[i] = mElems[i];
  }
  mSize = newSize; // Zapamitaj nowy rozmiar.
  delete [] mElems; // Zwolnij pami dla starej tablicy.
  mElems = newElems; // Zapamitaj wskanik na now tablic.

}

int& Array::operator[](int x)
{
  if (x < 0) {
    throw out_of_range("");
  }
  if (x >= mSize) {
    // Zaalokuj o kAllocSize elementw wicej ni chce klient.
    resize (x + kAllocSize);
  }
  return (mElems[x]);
}

const int& Array::operator[](int x) const
{
  if (x < 0 || x >=mSize) {
    throw out_of_range("");
  }
  return (mElems[x]);
}
