#include <fstream>
#include <iostream>
#include <vector>
#include <string>
#include <stdexcept>
#include <sstream>

using namespace std;

class FileError : public runtime_error
{
public:
  FileError(const string& fileIn) : runtime_error(""), mFile(fileIn) {}
  virtual ~FileError() throw() {}
  virtual const char* what() const throw() { return mMsg.c_str(); }
  string getFileName() { return mFile; }

protected:
  string mFile, mMsg;
};

class FileOpenError : public FileError
{
public:
  FileOpenError(const string& fileNameIn);
  virtual ~FileOpenError() throw() {}
};

FileOpenError::FileOpenError(const string& fileNameIn) : FileError(fileNameIn)
{
  mMsg = "Nie udao si otworzy pliku " + fileNameIn;
}

class FileReadError : public FileError
{
public:
  FileReadError(const string& fileNameIn, int lineNumIn);
  virtual ~FileReadError() throw() {}
  int getLineNum() { return mLineNum; }

protected:
  int mLineNum;
};

FileReadError::FileReadError(const string& fileNameIn, int lineNumIn) :
  FileError(fileNameIn), mLineNum(lineNumIn)
{
  ostringstream ostr;

  ostr << "Bd odczytu pliku " << fileNameIn << " w wierszu " << lineNumIn;
  mMsg = ostr.str();
}

void readIntegerFile(const string& fileName, vector<int>& dest)
  throw (FileOpenError, FileReadError) 
{
  ifstream istr;
  int temp;
  char line[1024]; // zaoenie, i aden wiersz nie jest duszy ni 1024 znaki
  int lineNumber = 0;

  istr.open(fileName.c_str());
  if (istr.fail()) {
    // Nie udao si otworzy pliku. Zgo wyjtek.
    throw FileOpenError(fileName);
  }

  while (!istr.eof()) {
    // Odczytaj wiersz z pliku.
    istr.getline(line, 1024);
    lineNumber++;

    // Otwrz z wiersza strumie.
    istringstream lineStream(line);

    // Odczytuje kolejne wartoci cakowite i dodaje je do wektora.
    while (lineStream >> temp) {
      dest.push_back(temp);
    }

    if (!lineStream.eof()) {
      // Inny bd. Zamknij plik i zgo wyjtek.
      istr.close();
      throw FileReadError(fileName, lineNumber);
    }
  }
  istr.close();
}

int main(int argc, char** argv)
{
  vector<int> myInts;
  const string fileName = "IntegerFile.txt";

  try {
    readIntegerFile(fileName, myInts);
  } catch (const FileError& e) {
    cerr << e.what() << endl;
    exit (1);
  }

  for (unsigned int i = 0; i < myInts.size(); i++) {
    cout << myInts[i] << " ";
  }
  cout << endl;

  return (0);
}
