// GameBoard.cpp
#include "GameBoard.h"

using namespace std;

// Microsoft Visual Studio requires you to omit the following two lines.
// However, some compilers require them.
//const int GameBoard::kDefaultWidth;
//const int GameBoard::kDefaultHeight;

GameBoard::GameBoard(int inWidth, int inHeight) throw(bad_alloc) :
  mWidth(inWidth), mHeight(inHeight)
{
  int i, j;
  mCells = new GamePiece* [mWidth];

  try {
    for (i = 0; i < mWidth; i++) {
      mCells[i] = new GamePiece[mHeight];
    }
  } catch (...) {
    //
    // Zwolnienie caej zaalokowanej do tej pory pamici, poniewa destruktor
    // nigdy nie zostanie wywoany. Grna granica ptli for to indeks ostatniego
    // elementu tablicy mCells, ktry prbowalimy zaalokowa (to dla niego 
    // wystpi bd). Wszystkie wczeniejsze indeksy zawieraj wskaniki, ktre
    // musz zosta zwolnione.
    //
    for (j = 0; j < i; j++) { 
      delete [] mCells[j];
    }
    delete [] mCells;

    // zmiana dowolnego wyjtku na bad_alloc
    throw bad_alloc();
  }
}

GameBoard::GameBoard(const GameBoard& src) throw (bad_alloc)
{
  copyFrom(src);
}

GameBoard::~GameBoard() throw()
{
  //zwolnienie starej pamici
  for (int i = 0; i < mWidth; i++) {
    delete [] mCells[i];
  }

  delete [] mCells;
}

GameBoard& GameBoard::operator=(const GameBoard& rhs) throw (bad_alloc)
{
  // sprawdzenie przypisania samego siebie
  if (this == &rhs) {
    return (*this);
  }
  // zwolnienie starej pamici
  for (int i = 0; i < mWidth; i++) {
    delete [] mCells[i];
  }
  delete [] mCells;

  //kopiowane nowej pamici
  copyFrom(rhs);

  return (*this);
}

void GameBoard::copyFrom(const GameBoard& src) throw(bad_alloc)
{
  int i, j;
  mWidth = src.mWidth;
  mHeight = src.mHeight;

  mCells = new GamePiece *[mWidth];

  try {
    for (i = 0; i < mWidth; i++) {
      mCells[i] = new GamePiece[mHeight];
    }
  } catch (...) {
    // Czyszczenie wczeniej zaalokowanej pamici.
    // Jeli ta funkcja zosta wywoana przez konstruktor kopiujcy,
    // destruktor nigdy nie zostanie wywoany.
    // Uycie tej samej grnej granicy, co w konstruktorze.
    for (j = 0; j < i; j++) {
      delete [] mCells[j];
    }
    delete [] mCells;

    // Ustawienie mCells i mWidth na wartoci, ktre umoliwi
    // destruktorowi dziaanie bez zniszczenia czegokolwiek.
    // Ta funkcja jest wywoywana przez operator=, co oznacza, e obiekt
    // ju powsta i destruktor zostanie wywoany.
    mCells = NULL;
    mWidth = 0;
    throw bad_alloc();
  }

  for (i = 0; i < mWidth; i++) {
    for (j = 0; j < mHeight; j++) {
      mCells[i][j] = src.mCells[i][j];
    }
  }
}

void GameBoard::setPieceAt(int x, int y, const GamePiece& inElem)
  throw(out_of_range)
{
  // Sprawdzenie, czy argumenty s poza dopuszczalnym zakresem.
  if (x < 0 || x >= mWidth || y < 0 || y >= mHeight) {
    throw out_of_range("Bdna szeroko lub wysoko.");
  }
  mCells[x][y] = inElem;
}

GamePiece& GameBoard::getPieceAt(int x, int y) throw(out_of_range)
{
  // Sprawdzenie, czy argumenty s poza dopuszczalnym zakresem.
  if (x < 0 || x >= mWidth || y < 0 || y >= mHeight) {
    throw out_of_range("Bdna szeroko lub wysoko.");
  }
  return (mCells[x][y]);
}

const GamePiece& GameBoard::getPieceAt(int x, int y) const throw(out_of_range)
{
  // Sprawdzenie, czy argumenty s poza dopuszczalnym zakresem.
  if (x < 0 || x >= mWidth || y < 0 || y >= mHeight) {
    throw out_of_range("Bdna szeroko lub wysoko.");
  }
  return (mCells[x][y]);
}

