#include <fstream>
#include <iostream>
#include <vector>
#include <string>
#include <stdexcept>
#include <exception>

using namespace std;

void readIntegerFile(const string& fileName, vector<int>& dest)
{
  ifstream istr;
  int temp;

  istr.open(fileName.c_str());
  if (istr.fail()) {
    // Nie udao si otworzy pliku - zgo wyjtek.
    throw invalid_argument("");
  }

  // Odczytuje kolejne wartoci cakowite i dodaje je do wektora.
  while (istr >> temp) {
    dest.push_back(temp);
  }

  if (istr.eof()) {
    // Osignlimy koniec pliku.
    istr.close();
  } else {
    // Inny bd. Zgo wyjtek.
    istr.close();
    throw runtime_error("");
  }
}

void myTerminate()
{
  cout << "Niewyapany wyjtek!\n";
  exit(1);
}

int main(int argc, char** argv)
{
  vector<int> myInts;
  const string fileName = "IntegerFile.txt";

  set_terminate(myTerminate);

  readIntegerFile(fileName, myInts);

  for (size_t i = 0; i < myInts.size(); i++) {
    cerr << myInts[i] << " ";
  }
  cout << endl;

  return (0);
}
