#include <fstream>
#include <iostream>
#include <vector>
#include <string>
#include <stdexcept>

using namespace std;

void readIntegerFile(const string& fileName, vector<int>& dest)
  throw ();

void readIntegerFile(const string& fileName, vector<int>& dest)
  throw ()
{
  ifstream istr;
  int temp;

  istr.open(fileName.c_str());
  if (istr.fail()) {
    // Nie udao si otworzy pliku - zgo wyjtek.
    throw invalid_argument("");
  }

  // Odczytuje kolejne wartoci cakowite i dodaje je do wektora.
  while (istr >> temp) {
    dest.push_back(temp);
  }

  if (istr.eof()) {
    // Osignito koniec pliku.
    istr.close();
  } else {
    // Inny bd. Zgo wyjtek.
    istr.close();
    throw runtime_error("");
  }
}

int main(int argc, char** argv)
{
  vector<int> myInts;
  const string fileName = "IntegerFile.txt";

  try {
    readIntegerFile(fileName, myInts);
  } catch (const invalid_argument& e) {
    cerr << "Nieudane otwarcie pliku " << fileName << endl;
    exit (1);
  } catch (const runtime_error& e) {
    cerr << "Bd odczytu pliku " << fileName << endl;
    exit (1);
  }

  for (size_t i = 0; i < myInts.size(); i++) {
    cout << myInts[i] << " ";
  }
  cout << endl;

  return (0);
}
