template <typename T>
class OneDGrid
{
    public:
        OneDGrid(int inSize = kDefaultSize);
        OneDGrid(const OneDGrid<T>& src);
        ~OneDGrid();

        OneDGrid<T> &operator=(const OneDGrid<T>& rhs);
        void resize(int newSize);

        T& operator[](int x);
        const T& operator[](int x) const;
        int getSize() const { return mSize; }
        static const int kDefaultSize = 10;
    protected:
        void copyFrom(const OneDGrid<T>& src);
        T* mElems;
        int mSize;
};

template <typename T>
const int OneDGrid<T>::kDefaultSize;

template <typename T>
OneDGrid<T>::OneDGrid(int inSize) : mSize(inSize)
{
    mElems = new T[mSize];
}

template <typename T>
OneDGrid<T>::OneDGrid(const OneDGrid<T>& src)
{
    copyFrom(src);
}

template <typename T>
OneDGrid<T>::~OneDGrid()
{
    delete [] mElems;
}

template <typename T>
void OneDGrid<T>::copyFrom(const OneDGrid<T>& src)
{
    mSize = src.mSize;
    mElems = new T[mSize];

    for (int i = 0; i < mSize; i++) {
        mElems[i] = src.mElems[i];
    }
}

template <typename T>
OneDGrid<T>& OneDGrid<T>::operator=(const OneDGrid<T>& rhs)
{
    // ochrona przed przypisaniem do samego siebie
    if (this == &rhs) {
        return (*this);
    }

    // zwolnienie zbdnej ju pamici
    delete [] mElems;

    // kopiowanie nowej pamici
    copyFrom(rhs);
    return (*this);
}

template <typename T>
void OneDGrid<T>::resize(int newSize)
{
    T* newElems = new T[newSize]; // alokacja nowej tablicy o wielkoci newSize

    // Obsuga sytuacji, kiedy nowy rozmiar rni si od dotychczasowego.
    for (int i = 0; i < newSize && i < mSize; i++) {
        // kopiowanie elementw starej tablicy do nowej
        newElems[i] = mElems[i];
    }
    mSize = newSize; // zapis nowej wielkoci
    delete [] mElems; // zwolnienie pamici uywanej przez star tablic
    mElems = newElems; // zapis wskanika na now tablic
}

template <typename T>
T& OneDGrid<T>::operator[](int x)
{
    return (mElems[x]);
}

template <typename T>
const T& OneDGrid<T>::operator[](int x) const
{
    return (mElems[x]);
}

