// GameBoard.h

class GamePiece {};

class GameBoard
{
    public:
        // Klasa oglnego przeznaczenia GameBoard, pozwala uytkownikowi poda
        // podane wymiary.
        GameBoard(int inWidth = kDefaultWidth, int inHeight = kDefaultHeight);
        GameBoard(const GameBoard& src); // copy constructor
        ~GameBoard();
        GameBoard& operator=(const GameBoard& rhs); // operator przypisania

        void setPieceAt(int x, int y, const GamePiece& inPiece);
        GamePiece& getPieceAt(int x, int y);
        const GamePiece& getPieceAt(int x, int y) const;

        int getHeight() const { return mHeight; }
        int getWidth() const { return mWidth; }
        static const int kDefaultWidth = 10;
        static const int kDefaultHeight = 10;

    protected:
        void copyFrom(const GameBoard& src);
        // obiekty dynamicznie alokuj pami na bierki.
        GamePiece** mCells;
        int mWidth, mHeight;
};
