// GameBoard.cpp
#include "GameBoard.h"

// Microsoft Visual Studio wymaga pominicia poniszych dwch wierszy.
// Jednak niektre kompilatory ich wymagaj.
//const int GameBoard::kDefaultWidth;
//const int GameBoard::kDefaultHeight;

GameBoard::GameBoard(int inWidth, int inHeight) :
     mWidth(inWidth), mHeight(inHeight)
{
     mCells = new GamePiece* [mWidth];
     for (int i = 0; i < mWidth; i++) {
         mCells[i] = new GamePiece[mHeight];
     }
}

GameBoard::GameBoard(const GameBoard& src)
{
     copyFrom(src);
}

GameBoard::~GameBoard()
{
     // zwolnienie zbdnej ju pamici
     for (int i = 0; i < mWidth; i++) {
         delete [] mCells[i];
     }

     delete [] mCells;
}

void GameBoard::copyFrom(const GameBoard& src)
{
     int i, j;
     mWidth = src.mWidth;
     mHeight = src.mHeight;

     mCells = new GamePiece* [mWidth];
     for (i = 0; i < mWidth; i++) {
         mCells[i] = new GamePiece[mHeight];
     }
     for (i = 0; i < mWidth; i++) {
         for (j = 0; j < mHeight; j++) {
             mCells[i][j] = src.mCells[i][j];
         }
     }
}

GameBoard& GameBoard::operator=(const GameBoard& rhs)
{
     // sprawdzenie, czy nie jest to przypisanie do siebie samego
     if (this == &rhs) {
         return (*this);
     }
     // zwolnienie zbdnej ju pamici
     for (int i = 0; i < mWidth; i++) {
         delete [] mCells[i];
     }
     delete [] mCells;

     // kopiowanie nowej pamici
     copyFrom(rhs);

     return (*this);
}

void GameBoard::setPieceAt(int x, int y, const GamePiece& inElem)
{
     mCells[x][y] = inElem;
}

GamePiece& GameBoard::getPieceAt(int x, int y)
{
     return (mCells[x][y]);
}

const GamePiece& GameBoard::getPieceAt(int x, int y) const
{
     return (mCells[x][y]);
}
