// WeatherPrediction.h

/**
 * Prognozuje pogod bazujc na sprawdzonych
 * technikach New Age; danymi wejciowymi s 
 * aktualna temperatura i odlego midzy Jowiszem
 * a Marsem. Jeli wartoci te nie zostan podane,
 * prognoza jest liczona i tak, ale jej dokadno
 * spada do zaledwie 99%.
 */
class WeatherPrediction
{
 public:
  virtual void setCurrentTempFahrenheit(int inTemp);
  virtual void setPositionOfJupiter(int inDistanceFromMars);

  /**
   * Pobiera prognoz temperatury na nastpny dzie.
   */
  virtual int getTomorrowTempFahrenheit();

  /**
   * Pobiera prawdopodobiestwo opadw nastpnego dnia. 
   * 1 to pewny deszcz, 0 wyklucza moliwo opadw.
   */
  virtual double getChanceOfRain();

  /**
   * Pokazuje uytkownikowi wyniki w formacie
   * Wynik: x.xx szans. Temp. xx
   */
  virtual void showResult();

 protected:
  int mCurrentTempFahrenheit;
  int mDistanceFromMars;
};
