#include <iostream>

#include "MyWeatherPrediction.h"

using namespace std;

void MyWeatherPrediction::setCurrentTempCelsius(int inTemp)
{
  int fahrenheitTemp = convertCelsiusToFahrenheit(inTemp);
  setCurrentTempFahrenheit(fahrenheitTemp);
}

int MyWeatherPrediction::getTomorrowTempCelsius()
{
  int fahrenheitTemp = getTomorrowTempFahrenheit();
  return convertFahrenheitToCelsius(fahrenheitTemp);
}

void MyWeatherPrediction::showResult()
{
  cout << "Jutro bdzie " << 
    getTomorrowTempCelsius() << " stopni Celsjusza (" <<
    getTomorrowTempFahrenheit() << " stopni Fahrenheita)" << endl;

  cout << "Prawdopodobiestwo opadw to " << (getChanceOfRain() * 100) 
       << " procent" << endl;

  if (getChanceOfRain() > 0.5) {
    cout << "We parasol!" << endl;
  }
}

int MyWeatherPrediction::convertCelsiusToFahrenheit(int inCelsius)
{
  return (int)((9.0/5.0) * (inCelsius + 32));
}

int MyWeatherPrediction::convertFahrenheitToCelsius(int inFahrenheit)
{
  return (int)((5.0/9.0) * (inFahrenheit-32));
}


int main()
{
  MyWeatherPrediction p;
  p.setCurrentTempCelsius(33);
  p.setPositionOfJupiter(80);
  p.showResult();
}
