// AirlineTicket.cpp

#include <iostream>
#include "AirlineTicket.h"

using namespace std;

AirlineTicket::AirlineTicket()
{
  // inicjalizacja pl klasy
  fHasEliteSuperRewardsStatus = false; 
  mPassengerName = "Pasaer nieznany";
  mNumberOfMiles = 0;
}

AirlineTicket::~AirlineTicket()
{
  // nie ma nic istotnego do sprztania
}

int AirlineTicket::calculatePriceInDollars()
{
  if (getHasEliteSuperRewardsStatus()) {
    // klienci z programu promocyjnego lataj za darmo!
    return 0;
  }
 
  // Koszt biletu to liczba mil razy 0.1. W prawdziwym liniach
  // lotniczych zasady s znacznie bardziej skomplikowane!
  return static_cast<int>((getNumberOfMiles() * 0.1));
}

string AirlineTicket::getPassengerName()
{
  return mPassengerName;
}

void AirlineTicket::setPassengerName(string inName)
{
  mPassengerName = inName;
}

int AirlineTicket::getNumberOfMiles()
{
  return mNumberOfMiles;
}

void AirlineTicket::setNumberOfMiles(int inMiles)
{
  mNumberOfMiles = inMiles;
}

bool AirlineTicket::getHasEliteSuperRewardsStatus()
{
  return fHasEliteSuperRewardsStatus;
}

void AirlineTicket::setHasEliteSuperRewardsStatus(bool inStatus)
{
  fHasEliteSuperRewardsStatus = inStatus;
}
