/**
 * Logger.h
 *
 * Definicja klasy dziennika typu singleton, implementowanej za pomoc metod statycznych.
 */

#include <iostream>
#include <fstream>
#include <vector>
class Logger
{
 public:
  static const std::string kLogLevelDebug;
  static const std::string kLogLevelInfo;
  static const std::string kLogLevelError;

  // Rejestruje jeden komunikat o podanym poziomie.
  static void log(const std::string& inMessage, 
          const std::string& inLogLevel);

  // Rejestuje wektor komunikatw o podanym poziomie.
  static void log(const std::vector<std::string>& inMessages, 
          const std::string& inLogLevel);

  // Zamyka dziennik.
  static void teardown();

 protected:
  static void init();

  static const char* const kLogFileName;

  static bool sInitialized;
  static std::ofstream sOutputStream;

 private:
  Logger() {}

};
