/**
 * Logger.cpp
 *
 * Implementacja klasy dziennika.
 */
#include <string>
#include "Logger.h"

using namespace std;

const string Logger::kLogLevelDebug = "DIAG";
const string Logger::kLogLevelInfo = "INFO";
const string Logger::kLogLevelError = "BD";

const char* const Logger::kLogFileName = "log.out";

// Obiekt statyczny jest tworzony w czasie uruchamiania programu
// i usuwany w czasie koczenia pracy.
Logger Logger::sInstance;

Logger& Logger::instance()
{
  return sInstance;
}

Logger::~Logger()
{
  mOutputStream.close();
}

Logger::Logger()
{
  mOutputStream.open(kLogFileName, ios_base::app);
  if (!mOutputStream.good()) {
    cerr << "Nie mona zainicjowa obiektu Logger!" << endl;
  } 
}

void Logger::log(const string& inMessage, const string& inLogLevel)
{
  mOutputStream << inLogLevel << ": " << inMessage << endl;
}

void Logger::log(const vector<string>& inMessages, const string& inLogLevel)
{
  for (size_t i = 0; i < inMessages.size(); i++) {
    log(inMessages[i], inLogLevel);
  }
}


int main(int argc, char** argv)
{
  Logger::instance().log("komunikat testowy", Logger::kLogLevelDebug);

  vector<string> items;
  items.push_back("element1");
  items.push_back("element2");

  Logger::instance().log(items, Logger::kLogLevelError);
}
