/**
 * CarFactory.cpp
 */

#include "CarFactory.h"

// Inicjalizacja licznika wartoci zero w czasie tworzenia obiektu factory.
CarFactory::CarFactory() : mNumCarsInProduction(0) {}

// Zwikszenie liczby samochodw w produkcji i 
// zwrcenie nowego samochodu.
Car* CarFactory::requestCar()
{
  mNumCarsInProduction++;
  return createCar();
}

int CarFactory::getNumCarsInProduction() const
{
  return mNumCarsInProduction;
}

Car* FordFactory::createCar()
{
  return new Ford();
}

Car* ToyotaFactory::createCar()
{
  return new Toyota();
}
