#include <sstream>
#include <xercesc/util/PlatformUtils.hpp>
#include <xercesc/framework/MemBufInputSource.hpp>
#include <xercesc/dom/DOM.hpp>
#include <xercesc/parsers/XercesDOMParser.hpp>
#include <xercesc/util/XMLString.hpp>

#include "Simple.h"
#include "XMLElement.h"

XERCES_CPP_NAMESPACE_USE
using namespace std;

string Simple::toXML() 
{
  XMLElement simpleElement;
  simpleElement.setElementName("simple");
  simpleElement.setAttribute("name", mName);

  // konwersja int na cig znakw
  ostringstream tempStream;
  tempStream << mPriority;
  simpleElement.setAttribute("priority", tempStream.str());

  // dodanie danych jako wze tekstowy
  simpleElement.setTextNode(mData);

  // konwersja XMLElement na cig znakw
  ostringstream resultStream;
  resultStream << simpleElement;

  return resultStream.str();
}

void Simple::fromXML(const string& inString)
{
  static const char* bufID = "zwyky bufor";

  MemBufInputSource src((const XMLByte*)inString.c_str(), inString.length(), bufID);
  XercesDOMParser* parser = new XercesDOMParser();
  parser->parse(src);

  DOMNode* node = parser->getDocument();
  DOMDocument* document = dynamic_cast<DOMDocument*>(node);
  if (document == NULL) {
    delete parser;
    return;
  }

  // dokument powinien by elementem <simple>
  try {
    const DOMElement& elementNode = dynamic_cast<const DOMElement&>(*document->getDocumentElement());

    // pobranie atrybutu name
    XMLCh* nameKey = XMLString::transcode("name");
    char* name = XMLString::transcode(elementNode.getAttribute(nameKey));
    XMLString::release(&nameKey);
    mName = name;
    XMLString::release(&name);

    // pobranie atrybutu priority
    XMLCh* priorityKey = XMLString::transcode("priority");
    char* priorityStr = XMLString::transcode(elementNode.getAttribute(priorityKey));
    XMLString::release(&priorityKey);
    // analiza wartoci priority
    istringstream tmpStream(priorityStr);
    tmpStream >> mPriority;
    XMLString::release(&priorityStr);

    // pobranie danych jako wze tekstowy
    const XMLCh* textData = elementNode.getTextContent();
    char* data = XMLString::transcode(textData);
    mData = data;
    XMLString::release(&data);

  } catch (bad_cast) {
    cerr << "wyjtek rzutowania w czasie parsowania obiektu Simple z XML" << endl;
  } catch (...) {
    cerr << "wystpi nieznany bd w czasie parsowania obiektu Simple z XML" << endl;
  }
  
  delete parser;
}

int main()
{
  XMLPlatformUtils::Initialize();

  Simple test;
  test.mName = "nazwa";
  test.mPriority = 7;
  test.mData = "dane";

  string xmlData = test.toXML();

  Simple test2;
  test2.fromXML(xmlData);

  if (test.mName == test2.mName) {
    cout << "Nazwy sobie odpowiadaj!" << endl;
  } else {
    cout << "BD: Nazwy sobie nie odpowiadaj!" << endl;
  }

  if (test.mPriority == test2.mPriority) {
    cout << "Priorytety s rwne!" << endl;
  } else {
    cout << "BD: Priorytety nie s rwne!" << endl;
  } 

  if (test.mData == test2.mData) {
    cout << "Dane s takie same!" << endl;
  } else {
    cout << "BD: Dane nie s takie same!" << endl;
  }

  XMLPlatformUtils::Terminate();
}
